/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sante)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef _CREAVTKUNMOSAICVECTORVTKIMAGEDATA_H_
#define _CREAVTKUNMOSAICVECTORVTKIMAGEDATA_H_
#include <vector>
#include "iostream"
#include "vtkImageData.h"
//---------------------------------------------
// Class Name: creaVtkUnMosaicVectorVtkImageData
// [classdescription]
//---------------------------------------------

class creaVtkUnMosaicVectorVtkImageData
{

//---------------------------------------------
//Methods and attributes exposed to other classes
//---------------------------------------------
public :
  creaVtkUnMosaicVectorVtkImageData();
  ~creaVtkUnMosaicVectorVtkImageData();
	std::vector<vtkImageData*> unMosaicVectorVtkImageData (std::vector<vtkImageData*> bbGetInputIn, std::vector<int> NbImagesInMosaicVector);
	vtkImageData * unMosaic(vtkImageData *imageIn, int nbImagesPerRow, int numberOfImagesInMosaic);

//--Method template----------------------------
//  void FunctionName(int& parameterA);


//---------------------------------------------
//Methods and attributes exposed only to classes
//that are derived from this class
//---------------------------------------------
protected:

//---------------------------------------------
//Methods and attributes only visible by this class
//---------------------------------------------
private:

};

//-end of _CREAVTKUNMOSAICVECTORVTKIMAGEDATA_H_------------------------------------------------------
#endif
