# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


#-----------------------------------------------------------------------------
#
# bbcreaMiniToolsConfig.cmake - CMake configuration file for external projects.
# This file was automatically generated by the cmake macro 
# CREA_INSTALL_LIBRARY_FOR_CMAKE of the package CREA
#
# This file is configured by cmake and used by the
# UsebbcreaMiniTools.cmake module to load the lib settings 
# for an external project.

# Build tree config ?
SET(CILC_BUILD_TREE_CONFIGURATION FALSE)


IF(UNIX)
SET(GOTO_INSTALL_PREFIX /../../..)
ENDIF(UNIX)


# The bbcreaMiniTools include file *RELATIVE* directories.
SET(CILC_RELATIVE_INCLUDE_PATHS "include/bbcreaMiniTools")
# Compute the prefix for include and library paths
IF(CILC_BUILD_TREE_CONFIGURATION)
  # In build tree 
  # the include paths are relative to the source tree *AND* the binary tree 
  # for generated files 
  SET(CILC_INCLUDE_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_source/creaMiniTools)
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(bbcreaMiniTools_INCLUDE_DIRS
      ${bbcreaMiniTools_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
  SET(CILC_INCLUDE_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_bin/creaMiniToolsBin)
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(bbcreaMiniTools_INCLUDE_DIRS
      ${bbcreaMiniTools_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
ELSE(CILC_BUILD_TREE_CONFIGURATION)
  # In install tree 
  # the include paths are relative to install prefix 
  # On unix , GOTO_INSTALL_PREFIX allows to get back to the 
  # installation prefix from  bbcreaMiniTools_DIR
  SET(CILC_INCLUDE_PATH_PREFIX ${bbcreaMiniTools_DIR}${GOTO_INSTALL_PREFIX})
  # Build the *ABSOLUTE* directories
  FOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
    SET(bbcreaMiniTools_INCLUDE_DIRS
      ${bbcreaMiniTools_INCLUDE_DIRS}
      ${CILC_INCLUDE_PATH_PREFIX}/${path}
      )
  ENDFOREACH(path ${CILC_RELATIVE_INCLUDE_PATHS})
ENDIF(CILC_BUILD_TREE_CONFIGURATION)



# Compute the prefix for library paths
IF(CILC_BUILD_TREE_CONFIGURATION)
  # In build tree
  # the library paths are relative to the binary tree 
  SET(CILC_LIBRARY_PATH_PREFIX /home/davila/Creatis/creaTools/creatools_bin/creaMiniToolsBin)
ELSE(CILC_BUILD_TREE_CONFIGURATION)
  # In install tree 
  # the library paths are relative to install prefix
  SET(CILC_LIBRARY_PATH_PREFIX ${bbcreaMiniTools_DIR}${GOTO_INSTALL_PREFIX})
ENDIF(CILC_BUILD_TREE_CONFIGURATION)
# The bbcreaMiniTools library file *RELATIVE* directories.
SET(CILC_RELATIVE_LIBRARY_PATHS "lib64/creatools")
# Build the *ABSOLUTE* directories
FOREACH(path ${CILC_RELATIVE_LIBRARY_PATHS})
  SET(bbcreaMiniTools_LIBRARY_DIRS
    ${bbcreaMiniTools_LIBRARY_DIRS}
    ${CILC_LIBRARY_PATH_PREFIX}/${path}
    )
ENDFOREACH(path ${CILC_RELATIVE_LIBRARY_PATHS})

# Set the "prefix path"
SET(bbcreaMiniTools_INSTALL_PREFIX ${CILC_LIBRARY_PATH_PREFIX})

# The C and C++ flags added by bbcreaMiniTools to the cmake-configured flags.
SET(bbcreaMiniTools_REQUIRED_C_FLAGS "")
SET(bbcreaMiniTools_REQUIRED_CXX_FLAGS "")
SET(bbcreaMiniTools_REQUIRED_LINK_FLAGS "")

# The bbcreaMiniTools version 
SET(bbcreaMiniTools_MAJOR_VERSION 1)
SET(bbcreaMiniTools_MINOR_VERSION 0)
SET(bbcreaMiniTools_BUILD_VERSION 0)
SET(bbcreaMiniTools_VERSION 1.0.0)

# The location of the UsebbcreaMiniTools.cmake file.
SET(bbcreaMiniTools_USE_FILE "${bbcreaMiniTools_DIR}/UsebbcreaMiniTools.cmake")

# The build settings file.
SET(bbcreaMiniTools_BUILD_SETTINGS_FILE 
  "${bbcreaMiniTools_DIR}/bbcreaMiniToolsBuildSettings.cmake")

# A list of all libraries for bbcreaMiniTools.  Those listed here should
# automatically pull in their dependencies.
SET(bbcreaMiniTools_LIBRARIES bbcreaMiniTools)

# Messages
IF(CREA_VERBOSE_CMAKE)
  MESSAGE(STATUS "=======================================")
  MESSAGE(STATUS "Looking for bbcreaMiniTools... found:")
  MESSAGE(STATUS "* bbcreaMiniTools_DIR          = ${bbcreaMiniTools_DIR}")
  MESSAGE(STATUS "* bbcreaMiniTools_VERSION      = ${bbcreaMiniTools_VERSION}")
  MESSAGE(STATUS "* bbcreaMiniTools_USE_FILE     = ${bbcreaMiniTools_USE_FILE}")

  MESSAGE(STATUS "* bbcreaMiniTools_INCLUDE_DIRS = ${bbcreaMiniTools_INCLUDE_DIRS}")
  MESSAGE(STATUS "* bbcreaMiniTools_LIBRARY_DIRS = ${bbcreaMiniTools_LIBRARY_DIRS}")
  MESSAGE(STATUS "* bbcreaMiniTools_LIBRARIES    = ${bbcreaMiniTools_LIBRARIES}")
ENDIF(CREA_VERBOSE_CMAKE)

# Does the library has an additional config file (user provided) ?
SET(bbcreaMiniTools_HAS_ADDITIONAL_CONFIG_FILE TRUE)

IF (bbcreaMiniTools_HAS_ADDITIONAL_CONFIG_FILE)
  IF(CREA_VERBOSE_CMAKE)
    MESSAGE(STATUS "Reading bbcreaMiniTools additional configuration file")
  ENDIF(CREA_VERBOSE_CMAKE)
  # Include it
  INCLUDE(${bbcreaMiniTools_DIR}/AdditionalbbcreaMiniToolsConfig.cmake)
ENDIF (bbcreaMiniTools_HAS_ADDITIONAL_CONFIG_FILE)
