 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */




MACRO(BBTK_BUILD_LATEX_DOC TEX_FILE OUTPUT_REL_PATH)


  # Need LaTeX
  SET(USE_LATEX ON CACHE BOOL "" FORCE)
  # Construct absolute build path
  SET(BUILD_PATH ${BBTK_DOC_BUILD_PATH}/${OUTPUT_REL_PATH})
  #MESSAGE(STATUS "Tex file : ${TEX_FILE}")
  #---------------------------------------------------------------------------
  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/${TEX_FILE}.tex
    ${BUILD_PATH}/${TEX_FILE}.tex
    COPYONLY
    )

  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    ${BUILD_PATH}/config.tex
    @ONLY
    )
  CONFIGURE_FILE(
    ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    ${CMAKE_CURRENT_BINARY_DIR}/config.tex
    @ONLY
    )
  #---------------------------------------------------------------------------
 FILE(TO_NATIVE_PATH ${BUILD_PATH} THE_BUILD_PATH)
#message("BBTKBUILLATEXDOC;CMAKE LATEX COMPILER + ${LATEX_COMPILER}")
  # Have to run latex twice to get references, toc, etc.
 # ADD_CUSTOM_COMMAND(
 #   OUTPUT ${BUILD_PATH}/${TEX_FILE}.aux 
 #   COMMAND 
    # latex
 #   cd ${THE_BUILD_PATH} && ${LATEX_COMPILER}
 #   ARGS
 #   -interaction=batchmode ${BUILD_PATH}/${TEX_FILE} -output-directory=${BUILD_PATH}/
    
 #   DEPENDS 
 #   ${CMAKE_CURRENT_SOURCE_DIR}/${TEX_FILE}.tex
 #   ${CMAKE_CURRENT_SOURCE_DIR}/../config.tex	
	
 #   )
  ADD_CUSTOM_COMMAND(
	OUTPUT ${BUILD_PATH}/${TEX_FILE}.aux
    COMMAND 
    # latex
    cd ${THE_BUILD_PATH} && ${LATEX_COMPILER}
    ARGS
    -interaction=batchmode ${BUILD_PATH}/${TEX_FILE} -output-directory=${BUILD_PATH}/
	
    OUTPUT ${BUILD_PATH}/${TEX_FILE}.pdf 
    COMMAND 
    # latex
    cd ${THE_BUILD_PATH} && ${LATEX_COMPILER}
    ARGS
    -interaction=batchmode ${BUILD_PATH}/${TEX_FILE} -output-directory=${BUILD_PATH}/
  
    #DEPENDS #${BUILD_PATH}/${TEX_FILE}.aux 
 	#${CMAKE_CURRENT_SOURCE_DIR}/${TEX_FILE}.tex
    #${CMAKE_CURRENT_SOURCE_DIR}/../config.tex
    )
  
  # pdf target
  ADD_CUSTOM_TARGET(${TEX_FILE}.pdf ALL
    DEPENDS ${BUILD_PATH}/${TEX_FILE}.pdf)

  # Install
  INSTALL( 
    FILES ${BUILD_PATH}/${TEX_FILE}.pdf
    DESTINATION ${BBTK_DOC_INSTALL_PATH}/${OUTPUT_REL_PATH}
    )  


ENDMACRO(BBTK_BUILD_LATEX_DOC)
