 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#----------------------------------------------------------------------------
IF(${BBTK_PACKAGE_NAME}_INCLUDE_ALL_BBS_BOXES) 

  FILE(GLOB 
    ${BBTK_PACKAGE_NAME}_BBS_BOXES 
    RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}
    "boxes/*.bbs"
    )

  FILE(GLOB 
    ${BBTK_PACKAGE_NAME}_BBG_BOXES 
    RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}
    "boxes/*.bbg"
    )


# !! Produces a cmake seg. fault :
#  FILE(GLOB 
#    ${BBTK_PACKAGE_NAME}_BBS_BOXES 
#    "boxes/"
#    )


ENDIF(${BBTK_PACKAGE_NAME}_INCLUDE_ALL_BBS_BOXES) 
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
IF(${BBTK_PACKAGE_NAME}_INCLUDE_ALL_BBS_APPLI) 

  FILE(GLOB ${BBTK_PACKAGE_NAME}_BBS_APPLI 
    RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}
    "appli/*.bbs"
    )
  FILE(GLOB ${BBTK_PACKAGE_NAME}_BBG_APPLI 
    RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}
    "appli/*.bbg"
    )


ENDIF(${BBTK_PACKAGE_NAME}_INCLUDE_ALL_BBS_APPLI) 
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
INCLUDE(${BBTK_CMAKE_DIR}/BBTKCreatePackageIncludeScript.cmake)

BBTK_CREATE_PACKAGE_INCLUDE_SCRIPT(
  "${BBTK_PACKAGE_NAME}"
  "${${BBTK_PACKAGE_NAME}_BBS_BOXES}"
  "${${BBTK_PACKAGE_NAME}_BBS_APPLI}"
  "${${BBTK_PACKAGE_NAME}_BBG_BOXES}"
  "${${BBTK_PACKAGE_NAME}_BBG_APPLI}"
  )
#----------------------------------------------------------------------------

  IF(NOT WIN32)
    # runs bbRegeneratePackageDoc and bbRegenerateBoxesLists 
    # as a post install step
    # does not work on windaube
    IF(NOT BBTK_CORE_PACKAGE)

##EED 25oct2010
#      INSTALL(CODE 
#	"EXECUTE_PROCESS(COMMAND echo -- Executing '${BBTK_BIN_PATH}/bbPostInstallPackage ${BBTK_PACKAGE_NAME}')"
#	)
#     INSTALL(CODE 
#	"EXECUTE_PROCESS(COMMAND ${BBTK_BIN_PATH}/bbPostInstallPackage ${BBTK_PACKAGE_NAME})"
#	)
# COMMAND cd ${BBTK_BIN_PATH} COMMAND export LD_LIBRARY_PATH=\"../lib:$ENV{LD_LIBRARY_PATH}\" COMMAND bbRegeneratePackageDoc ${BBTK_PACKAGE_NAME} COMMAND bbRegenerateBoxesLists COMMAND echo \"done\")")


    ENDIF(NOT BBTK_CORE_PACKAGE)
  ENDIF(NOT WIN32)


#----------------------------------------------------------------------------
#---------------------------------------------------------------------------
IF(BBTK_CORE_PACKAGE)
  # If a core package set option from bbtk global one
  IF (BUILD_BBS_APPLI_BINARIES)
    SET(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP OFF)
  ELSE (BUILD_BBS_APPLI_BINARIES)
    SET(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP OFF)
  ENDIF (BUILD_BBS_APPLI_BINARIES)
ELSE(BBTK_CORE_PACKAGE)
  # If not a core package 
  # Create the option
  OPTION(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP 
    "Build binaries for bbs applications of package ${BBTK_PACKAGE_NAME} ?" OFF)
##EED  SWITCH_ON_IF_BUILD_ALL(BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP)
ENDIF(BBTK_CORE_PACKAGE)
#---------------------------------------------------------------------------


IF (BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP)
  FOREACH(bbs ${${BBTK_PACKAGE_NAME}_BBS_APPLI})  
    GET_FILENAME_COMPONENT(name "${bbs}" NAME_WE) 
    SET(OUTPUT bb${name})
    ADD_CUSTOM_COMMAND(
      OUTPUT ${BBTK_BIN_PATH}/${OUTPUT}
      COMMAND 
      cd ${BBTK_BIN_PATH} && ${BBTK_BBC} ${BBTK_PACKAGE_NAME}/appli/${name}
      DEPENDS ${bbs}
      ${BBTK_BBS2CPP_DEPENDENCY} 
      )
    INSTALL(
      FILES ${BBTK_BIN_PATH}/${OUTPUT}
      DESTINATION bin
      PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE
      )
    ADD_CUSTOM_TARGET(
      ${OUTPUT} ALL
      DEPENDS ${BBTK_BIN_PATH}/${OUTPUT} 
      )
  ENDFOREACH(bbs)
ENDIF (BUILD_BBTK_PACKAGE_${BBTK_PACKAGE_NAME}_BBS_APP)
#----------------------------------------------------------------------------
