# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# This is an implementation detail for using crea with the
# Findcrea.cmake module.  Do not include directly by name.  
# This should be included only when Findcrea.cmake sets 
# the crea_USE_FILE variable to point here.

IF(CREA_VERBOSE_CMAKE)
  MESSAGE(STATUS "Using crea")
ENDIF(CREA_VERBOSE_CMAKE)

# Load the compiler settings used for crea.
IF(crea_BUILD_SETTINGS_FILE)
  INCLUDE(CMakeImportBuildSettings)
  CMAKE_IMPORT_BUILD_SETTINGS(${crea_BUILD_SETTINGS_FILE})
ENDIF(crea_BUILD_SETTINGS_FILE)

# Add compiler flags needed to use crea.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${crea_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${crea_REQUIRED_CXX_FLAGS}")
SET(CMAKE_LINK_FLAGS "${CMAKE_LINK_FLAGS} ${crea_REQUIRED_LINK_FLAGS}")

# Add include directories needed to use crea.
INCLUDE_DIRECTORIES(${crea_INCLUDE_DIRS})

# Add link directories needed to use crea.
LINK_DIRECTORIES(${crea_LIBRARY_DIRS})

# Set the version 
# Already done in bbtkConfigure.h
#ADD_DEFINITIONS( -Dcrea_VERSION="\"${crea_VERSION}\"" )

# Additional use file 
IF (crea_HAS_ADDITIONAL_CONFIG_FILE)
  # Include it
  INCLUDE(${crea_DIR}/AdditionalUsecrea.cmake)
ENDIF (crea_HAS_ADDITIONAL_CONFIG_FILE)
