# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if BaseVolumeRenderer is found.  
# If BaseVolumeRenderer is not found, BaseVolumeRenderer_FOUND is set to false.
#  BaseVolumeRenderer_FOUND         - Set to true when BaseVolumeRenderer is found.
#  BaseVolumeRenderer_USE_FILE      - CMake file to use BaseVolumeRenderer.
#  BaseVolumeRenderer_MAJOR_VERSION - The BaseVolumeRenderer major version number.
#  BaseVolumeRenderer_MINOR_VERSION - The BaseVolumeRenderer minor version number 
#                       (odd non-release).
#  BaseVolumeRenderer_BUILD_VERSION - The BaseVolumeRenderer patch level 
#                       (meaningless for odd minor).
#  BaseVolumeRenderer_INCLUDE_DIRS  - Include directories for BaseVolumeRenderer
#  BaseVolumeRenderer_LIBRARY_DIRS  - Link directories for BaseVolumeRenderer libraries
#  BaseVolumeRenderer_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate BaseVolumeRenderer:
#  BaseVolumeRenderer_DIR  - The directory containing BaseVolumeRendererConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/BaseVolumeRenderer directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(BaseVolumeRenderer_DIR_DESCRIPTION "directory containing BaseVolumeRendererConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/BaseVolumeRenderer for an installation.")
SET(BaseVolumeRenderer_NOT_FOUND_MESSAGE "BaseVolumeRenderer not found.  Set the BaseVolumeRenderer_DIR cmake cache entry to the ${BaseVolumeRenderer_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT BaseVolumeRenderer_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" BaseVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" BaseVolumeRenderer_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" BaseVolumeRenderer_DIR_SEARCH2 "${BaseVolumeRenderer_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(BaseVolumeRenderer_DIR_SEARCH "")
  FOREACH(dir ${BaseVolumeRenderer_DIR_SEARCH2})
    SET(BaseVolumeRenderer_DIR_SEARCH ${BaseVolumeRenderer_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/creaMaracasVisu
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(BaseVolumeRenderer_DIR UseBaseVolumeRenderer.cmake
    # Look for an environment variable BaseVolumeRenderer_DIR.
    $ENV{BaseVolumeRenderer_DIR}

    # Look in places relative to the system executable search path.
    ${BaseVolumeRenderer_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/BaseVolumeRenderer"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/creaMaracasVisu
    /usr/lib64/creatools/creaMaracasVisu

    # Read from the CMakeSetup registry entries.  It is likely that
    # BaseVolumeRenderer will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${BaseVolumeRenderer_DIR_DESCRIPTION}"
  )
ENDIF(NOT BaseVolumeRenderer_DIR)

# If BaseVolumeRenderer was found, load the configuration file to get the rest of the
# settings.
IF(BaseVolumeRenderer_DIR)
  # Make sure the BaseVolumeRendererConfig.cmake file exists in the directory provided.
  IF(EXISTS ${BaseVolumeRenderer_DIR}/BaseVolumeRendererConfig.cmake)

    # We found BaseVolumeRenderer.  Load the settings.
    SET(BaseVolumeRenderer_FOUND 1)
    INCLUDE(${BaseVolumeRenderer_DIR}/BaseVolumeRendererConfig.cmake)

  ENDIF(EXISTS ${BaseVolumeRenderer_DIR}/BaseVolumeRendererConfig.cmake)
ELSE(BaseVolumeRenderer_DIR)
  # We did not find BaseVolumeRenderer.
  SET(BaseVolumeRenderer_FOUND 0)
ENDIF(BaseVolumeRenderer_DIR)

#-----------------------------------------------------------------------------
IF(NOT BaseVolumeRenderer_FOUND)
  # BaseVolumeRenderer not found, explain to the user how to specify its location.
  IF(NOT BaseVolumeRenderer_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${BaseVolumeRenderer_NOT_FOUND_MESSAGE})
  ELSE(NOT BaseVolumeRenderer_FIND_QUIETLY)
    IF(BaseVolumeRenderer_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${BaseVolumeRenderer_NOT_FOUND_MESSAGE})
    ENDIF(BaseVolumeRenderer_FIND_REQUIRED)
  ENDIF(NOT BaseVolumeRenderer_FIND_QUIETLY)
ENDIF(NOT BaseVolumeRenderer_FOUND)
