# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaContours is found.  
# If bbcreaContours is not found, bbcreaContours_FOUND is set to false.
#  bbcreaContours_FOUND         - Set to true when bbcreaContours is found.
#  bbcreaContours_USE_FILE      - CMake file to use bbcreaContours.
#  bbcreaContours_MAJOR_VERSION - The bbcreaContours major version number.
#  bbcreaContours_MINOR_VERSION - The bbcreaContours minor version number 
#                       (odd non-release).
#  bbcreaContours_BUILD_VERSION - The bbcreaContours patch level 
#                       (meaningless for odd minor).
#  bbcreaContours_INCLUDE_DIRS  - Include directories for bbcreaContours
#  bbcreaContours_LIBRARY_DIRS  - Link directories for bbcreaContours libraries
#  bbcreaContours_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaContours:
#  bbcreaContours_DIR  - The directory containing bbcreaContoursConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaContours directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaContours_DIR_DESCRIPTION "directory containing bbcreaContoursConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaContours for an installation.")
SET(bbcreaContours_NOT_FOUND_MESSAGE "bbcreaContours not found.  Set the bbcreaContours_DIR cmake cache entry to the ${bbcreaContours_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaContours_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaContours_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaContours_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaContours_DIR_SEARCH2 "${bbcreaContours_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaContours_DIR_SEARCH "")
  FOREACH(dir ${bbcreaContours_DIR_SEARCH2})
    SET(bbcreaContours_DIR_SEARCH ${bbcreaContours_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaContours
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaContours_DIR UsebbcreaContours.cmake
    # Look for an environment variable bbcreaContours_DIR.
    $ENV{bbcreaContours_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaContours_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaContours"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaContours
    /usr/lib64/creatools/bbcreaContours

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaContours will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaContours_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaContours_DIR)

# If bbcreaContours was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaContours_DIR)
  # Make sure the bbcreaContoursConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaContours_DIR}/bbcreaContoursConfig.cmake)

    # We found bbcreaContours.  Load the settings.
    SET(bbcreaContours_FOUND 1)
    INCLUDE(${bbcreaContours_DIR}/bbcreaContoursConfig.cmake)

  ENDIF(EXISTS ${bbcreaContours_DIR}/bbcreaContoursConfig.cmake)
ELSE(bbcreaContours_DIR)
  # We did not find bbcreaContours.
  SET(bbcreaContours_FOUND 0)
ENDIF(bbcreaContours_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaContours_FOUND)
  # bbcreaContours not found, explain to the user how to specify its location.
  IF(NOT bbcreaContours_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaContours_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaContours_FIND_QUIETLY)
    IF(bbcreaContours_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaContours_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaContours_FIND_REQUIRED)
  ENDIF(NOT bbcreaContours_FIND_QUIETLY)
ENDIF(NOT bbcreaContours_FOUND)
