# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbcreaMiniToolsBase is found.  
# If bbcreaMiniToolsBase is not found, bbcreaMiniToolsBase_FOUND is set to false.
#  bbcreaMiniToolsBase_FOUND         - Set to true when bbcreaMiniToolsBase is found.
#  bbcreaMiniToolsBase_USE_FILE      - CMake file to use bbcreaMiniToolsBase.
#  bbcreaMiniToolsBase_MAJOR_VERSION - The bbcreaMiniToolsBase major version number.
#  bbcreaMiniToolsBase_MINOR_VERSION - The bbcreaMiniToolsBase minor version number 
#                       (odd non-release).
#  bbcreaMiniToolsBase_BUILD_VERSION - The bbcreaMiniToolsBase patch level 
#                       (meaningless for odd minor).
#  bbcreaMiniToolsBase_INCLUDE_DIRS  - Include directories for bbcreaMiniToolsBase
#  bbcreaMiniToolsBase_LIBRARY_DIRS  - Link directories for bbcreaMiniToolsBase libraries
#  bbcreaMiniToolsBase_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbcreaMiniToolsBase:
#  bbcreaMiniToolsBase_DIR  - The directory containing bbcreaMiniToolsBaseConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbcreaMiniToolsBase directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbcreaMiniToolsBase_DIR_DESCRIPTION "directory containing bbcreaMiniToolsBaseConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbcreaMiniToolsBase for an installation.")
SET(bbcreaMiniToolsBase_NOT_FOUND_MESSAGE "bbcreaMiniToolsBase not found.  Set the bbcreaMiniToolsBase_DIR cmake cache entry to the ${bbcreaMiniToolsBase_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbcreaMiniToolsBase_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbcreaMiniToolsBase_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbcreaMiniToolsBase_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbcreaMiniToolsBase_DIR_SEARCH2 "${bbcreaMiniToolsBase_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbcreaMiniToolsBase_DIR_SEARCH "")
  FOREACH(dir ${bbcreaMiniToolsBase_DIR_SEARCH2})
    SET(bbcreaMiniToolsBase_DIR_SEARCH ${bbcreaMiniToolsBase_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbcreaMiniToolsBase
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbcreaMiniToolsBase_DIR UsebbcreaMiniToolsBase.cmake
    # Look for an environment variable bbcreaMiniToolsBase_DIR.
    $ENV{bbcreaMiniToolsBase_DIR}

    # Look in places relative to the system executable search path.
    ${bbcreaMiniToolsBase_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbcreaMiniToolsBase"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbcreaMiniToolsBase
    /usr/lib64/creatools/bbcreaMiniToolsBase

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbcreaMiniToolsBase will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbcreaMiniToolsBase_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbcreaMiniToolsBase_DIR)

# If bbcreaMiniToolsBase was found, load the configuration file to get the rest of the
# settings.
IF(bbcreaMiniToolsBase_DIR)
  # Make sure the bbcreaMiniToolsBaseConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbcreaMiniToolsBase_DIR}/bbcreaMiniToolsBaseConfig.cmake)

    # We found bbcreaMiniToolsBase.  Load the settings.
    SET(bbcreaMiniToolsBase_FOUND 1)
    INCLUDE(${bbcreaMiniToolsBase_DIR}/bbcreaMiniToolsBaseConfig.cmake)

  ENDIF(EXISTS ${bbcreaMiniToolsBase_DIR}/bbcreaMiniToolsBaseConfig.cmake)
ELSE(bbcreaMiniToolsBase_DIR)
  # We did not find bbcreaMiniToolsBase.
  SET(bbcreaMiniToolsBase_FOUND 0)
ENDIF(bbcreaMiniToolsBase_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbcreaMiniToolsBase_FOUND)
  # bbcreaMiniToolsBase not found, explain to the user how to specify its location.
  IF(NOT bbcreaMiniToolsBase_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbcreaMiniToolsBase_NOT_FOUND_MESSAGE})
  ELSE(NOT bbcreaMiniToolsBase_FIND_QUIETLY)
    IF(bbcreaMiniToolsBase_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbcreaMiniToolsBase_NOT_FOUND_MESSAGE})
    ENDIF(bbcreaMiniToolsBase_FIND_REQUIRED)
  ENDIF(NOT bbcreaMiniToolsBase_FIND_QUIETLY)
ENDIF(NOT bbcreaMiniToolsBase_FOUND)
