# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbtoolsbbtk is found.  
# If bbtoolsbbtk is not found, bbtoolsbbtk_FOUND is set to false.
#  bbtoolsbbtk_FOUND         - Set to true when bbtoolsbbtk is found.
#  bbtoolsbbtk_USE_FILE      - CMake file to use bbtoolsbbtk.
#  bbtoolsbbtk_MAJOR_VERSION - The bbtoolsbbtk major version number.
#  bbtoolsbbtk_MINOR_VERSION - The bbtoolsbbtk minor version number 
#                       (odd non-release).
#  bbtoolsbbtk_BUILD_VERSION - The bbtoolsbbtk patch level 
#                       (meaningless for odd minor).
#  bbtoolsbbtk_INCLUDE_DIRS  - Include directories for bbtoolsbbtk
#  bbtoolsbbtk_LIBRARY_DIRS  - Link directories for bbtoolsbbtk libraries
#  bbtoolsbbtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbtoolsbbtk:
#  bbtoolsbbtk_DIR  - The directory containing bbtoolsbbtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbtoolsbbtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbtoolsbbtk_DIR_DESCRIPTION "directory containing bbtoolsbbtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbtoolsbbtk for an installation.")
SET(bbtoolsbbtk_NOT_FOUND_MESSAGE "bbtoolsbbtk not found.  Set the bbtoolsbbtk_DIR cmake cache entry to the ${bbtoolsbbtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbtoolsbbtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbtoolsbbtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbtoolsbbtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbtoolsbbtk_DIR_SEARCH2 "${bbtoolsbbtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbtoolsbbtk_DIR_SEARCH "")
  FOREACH(dir ${bbtoolsbbtk_DIR_SEARCH2})
    SET(bbtoolsbbtk_DIR_SEARCH ${bbtoolsbbtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbtoolsbbtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbtoolsbbtk_DIR Usebbtoolsbbtk.cmake
    # Look for an environment variable bbtoolsbbtk_DIR.
    $ENV{bbtoolsbbtk_DIR}

    # Look in places relative to the system executable search path.
    ${bbtoolsbbtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbtoolsbbtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbtoolsbbtk
    /usr/lib64/creatools/bbtoolsbbtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbtoolsbbtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbtoolsbbtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbtoolsbbtk_DIR)

# If bbtoolsbbtk was found, load the configuration file to get the rest of the
# settings.
IF(bbtoolsbbtk_DIR)
  # Make sure the bbtoolsbbtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbtoolsbbtk_DIR}/bbtoolsbbtkConfig.cmake)

    # We found bbtoolsbbtk.  Load the settings.
    SET(bbtoolsbbtk_FOUND 1)
    INCLUDE(${bbtoolsbbtk_DIR}/bbtoolsbbtkConfig.cmake)

  ENDIF(EXISTS ${bbtoolsbbtk_DIR}/bbtoolsbbtkConfig.cmake)
ELSE(bbtoolsbbtk_DIR)
  # We did not find bbtoolsbbtk.
  SET(bbtoolsbbtk_FOUND 0)
ENDIF(bbtoolsbbtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbtoolsbbtk_FOUND)
  # bbtoolsbbtk not found, explain to the user how to specify its location.
  IF(NOT bbtoolsbbtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbtoolsbbtk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbtoolsbbtk_FIND_QUIETLY)
    IF(bbtoolsbbtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbtoolsbbtk_NOT_FOUND_MESSAGE})
    ENDIF(bbtoolsbbtk_FIND_REQUIRED)
  ENDIF(NOT bbtoolsbbtk_FIND_QUIETLY)
ENDIF(NOT bbtoolsbbtk_FOUND)
