# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbwx is found.  
# If bbwx is not found, bbwx_FOUND is set to false.
#  bbwx_FOUND         - Set to true when bbwx is found.
#  bbwx_USE_FILE      - CMake file to use bbwx.
#  bbwx_MAJOR_VERSION - The bbwx major version number.
#  bbwx_MINOR_VERSION - The bbwx minor version number 
#                       (odd non-release).
#  bbwx_BUILD_VERSION - The bbwx patch level 
#                       (meaningless for odd minor).
#  bbwx_INCLUDE_DIRS  - Include directories for bbwx
#  bbwx_LIBRARY_DIRS  - Link directories for bbwx libraries
#  bbwx_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbwx:
#  bbwx_DIR  - The directory containing bbwxConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbwx directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbwx_DIR_DESCRIPTION "directory containing bbwxConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbwx for an installation.")
SET(bbwx_NOT_FOUND_MESSAGE "bbwx not found.  Set the bbwx_DIR cmake cache entry to the ${bbwx_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbwx_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbwx_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbwx_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbwx_DIR_SEARCH2 "${bbwx_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbwx_DIR_SEARCH "")
  FOREACH(dir ${bbwx_DIR_SEARCH2})
    SET(bbwx_DIR_SEARCH ${bbwx_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbwx
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbwx_DIR Usebbwx.cmake
    # Look for an environment variable bbwx_DIR.
    $ENV{bbwx_DIR}

    # Look in places relative to the system executable search path.
    ${bbwx_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbwx"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbwx
    /usr/lib64/creatools/bbwx

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbwx will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbwx_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbwx_DIR)

# If bbwx was found, load the configuration file to get the rest of the
# settings.
IF(bbwx_DIR)
  # Make sure the bbwxConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbwx_DIR}/bbwxConfig.cmake)

    # We found bbwx.  Load the settings.
    SET(bbwx_FOUND 1)
    INCLUDE(${bbwx_DIR}/bbwxConfig.cmake)

  ENDIF(EXISTS ${bbwx_DIR}/bbwxConfig.cmake)
ELSE(bbwx_DIR)
  # We did not find bbwx.
  SET(bbwx_FOUND 0)
ENDIF(bbwx_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbwx_FOUND)
  # bbwx not found, explain to the user how to specify its location.
  IF(NOT bbwx_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbwx_NOT_FOUND_MESSAGE})
  ELSE(NOT bbwx_FIND_QUIETLY)
    IF(bbwx_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbwx_NOT_FOUND_MESSAGE})
    ENDIF(bbwx_FIND_REQUIRED)
  ENDIF(NOT bbwx_FIND_QUIETLY)
ENDIF(NOT bbwx_FOUND)
