# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 


# - Find a library installation or build tree.
# 
# The following variables are set if bbwxvtk is found.  
# If bbwxvtk is not found, bbwxvtk_FOUND is set to false.
#  bbwxvtk_FOUND         - Set to true when bbwxvtk is found.
#  bbwxvtk_USE_FILE      - CMake file to use bbwxvtk.
#  bbwxvtk_MAJOR_VERSION - The bbwxvtk major version number.
#  bbwxvtk_MINOR_VERSION - The bbwxvtk minor version number 
#                       (odd non-release).
#  bbwxvtk_BUILD_VERSION - The bbwxvtk patch level 
#                       (meaningless for odd minor).
#  bbwxvtk_INCLUDE_DIRS  - Include directories for bbwxvtk
#  bbwxvtk_LIBRARY_DIRS  - Link directories for bbwxvtk libraries
#  bbwxvtk_LIBRARIES     - List of libraries to link against
#
# The following cache entries must be set by the user to locate bbwxvtk:
#  bbwxvtk_DIR  - The directory containing bbwxvtkConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/bbwxvtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(bbwxvtk_DIR_DESCRIPTION "directory containing bbwxvtkConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/bbwxvtk for an installation.")
SET(bbwxvtk_NOT_FOUND_MESSAGE "bbwxvtk not found.  Set the bbwxvtk_DIR cmake cache entry to the ${bbwxvtk_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT bbwxvtk_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" bbwxvtk_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" bbwxvtk_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" bbwxvtk_DIR_SEARCH2 "${bbwxvtk_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(bbwxvtk_DIR_SEARCH "")
  FOREACH(dir ${bbwxvtk_DIR_SEARCH2})
    SET(bbwxvtk_DIR_SEARCH ${bbwxvtk_DIR_SEARCH}
      ${dir}/../lib/lib64/creatools/bbwxvtk
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(bbwxvtk_DIR Usebbwxvtk.cmake
    # Look for an environment variable bbwxvtk_DIR.
    $ENV{bbwxvtk_DIR}

    # Look in places relative to the system executable search path.
    ${bbwxvtk_DIR_SEARCH}

    # Look in standard WIN install locations.
    "$ENV{ProgramFiles}/bbwxvtk"

    # Look in standard UNIX install locations.
    /usr/local/lib64/creatools/bbwxvtk
    /usr/lib64/creatools/bbwxvtk

    # Read from the CMakeSetup registry entries.  It is likely that
    # bbwxvtk will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${bbwxvtk_DIR_DESCRIPTION}"
  )
ENDIF(NOT bbwxvtk_DIR)

# If bbwxvtk was found, load the configuration file to get the rest of the
# settings.
IF(bbwxvtk_DIR)
  # Make sure the bbwxvtkConfig.cmake file exists in the directory provided.
  IF(EXISTS ${bbwxvtk_DIR}/bbwxvtkConfig.cmake)

    # We found bbwxvtk.  Load the settings.
    SET(bbwxvtk_FOUND 1)
    INCLUDE(${bbwxvtk_DIR}/bbwxvtkConfig.cmake)

  ENDIF(EXISTS ${bbwxvtk_DIR}/bbwxvtkConfig.cmake)
ELSE(bbwxvtk_DIR)
  # We did not find bbwxvtk.
  SET(bbwxvtk_FOUND 0)
ENDIF(bbwxvtk_DIR)

#-----------------------------------------------------------------------------
IF(NOT bbwxvtk_FOUND)
  # bbwxvtk not found, explain to the user how to specify its location.
  IF(NOT bbwxvtk_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${bbwxvtk_NOT_FOUND_MESSAGE})
  ELSE(NOT bbwxvtk_FIND_QUIETLY)
    IF(bbwxvtk_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${bbwxvtk_NOT_FOUND_MESSAGE})
    ENDIF(bbwxvtk_FIND_REQUIRED)
  ENDIF(NOT bbwxvtk_FIND_QUIETLY)
ENDIF(NOT bbwxvtk_FOUND)
