
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------  


#!/bin/bash

OperatingSystem=$1
echo "OperatingSystem = $OperatingSystem"

# the following stupid test is used at debug time; Please don't remove!
if [ true = true ]
#if [ true = false ]
then
  # ///\TODO what about SuSE? Debian? Mandriva? Gentoo?
  case "$OperatingSystem" in
  Mandriva)
     urpmi cmake                
     urpmi cmake-qtgui            
     urpmi doxygen              
     urpmi graphviz             
     urpmi texlive              
     urpmi latex2html           
     urpmi libwxgtk2.8    
     urpmi lib64wxgtk2.8    
     urpmi boost-devel          
     urpmi sqlite-devel         
     urpmi qt4-common
     urpmi libqt4-devel             
     urpmi lib64qt4-devel             
     #urpmi mesa-libOSMesa-devel 
     urpmi lib64mesagl1-devel
     urpmi libmesagl1-devel
     urpmi lib64xt-devel
     urpmi libxt-devel
     urpmi lib64wxgtk2.8-devel
     urpmi libwxgtk2.8-devel
     urpmi gcc-c++
     urpmi git
     urpmi rpm-build
     urpmi patch ### EED It's working ???

     ;;
  Fedora)
     yum install wget                 -y
     yum install unzip                -y
     yum install cmake                -y
     yum install cmake-gui            -y
     yum install doxygen              -y
     yum install graphviz             -y
     yum install texlive              -y
     yum install latex2html           -y
     yum install wxGTK-devel wxBase   -y
     yum install boost-devel          -y
     yum install sqlite-devel         -y
     yum install qt-devel             -y
     yum install mesa-libOSMesa-devel -y
     yum install gcc                  -y
     yum install gcc-c++              -y
     yum install xerces-c-devel       -y
     yum install git                  -y
     yum install qtwebkit-devel       -y
     yum install patch                -y

     ;;
  Ubuntu)
     apt-get --yes install build-essential  # esta linea instala las librerias necesarias para compilar en ubuntu, g++ gcc etc etc etc.
     apt-get --yes install git
     apt-get --yes install cmake
     apt-get --yes install cmake-gui
     apt-get --yes install cmake-curses-gui
     apt-get --yes install doxygen
     apt-get --yes install graphviz
     apt-get --yes install texlive
     apt-get --yes install latex2html
     apt-get --yes install libgtk2.0-dev #GTK
     apt-get --yes install libwxgtk2.8-dev #Wx GTK
     apt-get --yes install libwxbase2.8-dev #Wx solito
     apt-get --yes install wx-common #wxrc
     apt-get --yes install libboost-dev  #Boost
     apt-get --yes install libboost-all-dev #Boost
     apt-get --yes install libqt4-dev #QT4
     apt-get --yes install libxerces-c-dev
     apt-get --yes install patch
     ## CLAIRE - JGRR
     apt-get --yes install qt4-qmake #QT4 qmake
     apt-get --yes install libsqlite0-dev
     apt-get --yes install libsqlite3-dev
     apt-get --yes install libosmesa6-dev #Mesa6
     apt-get --yes install uuid-dev # uuid para la instalacion de itk
     apt-get --yes install libxaw7-dev # X11
     ;;
  MacOS)
     port selfupdate
     port install cmake                -y
     port install doxygen              -y
     port install graphviz             -y
    # port install tetex               -y   (replaced by texlive) # cf EED : http://www.creatis.insa-lyon.fr/site/fr/CreatoolsInstallInstructionsv2.0.1MacOsv10.5.6-Developpers
     port install texlive              -y
     port install latex2html           -y
     port install wxGTK                -y
     port install boost                -y
     ln -s libboost_signals-xgcc40-mt-1_38.dylib    libboost_signals.dylib    /opt/local/lib # cf EED : http://www.creatis.insa-lyon.fr/site
     ln -s libboost_signals-xgcc40-mt-1_38.dylib    libboost_signals.dylib    /opt/local/lib # cf EED
     ln -s libboost_filesystem-xgcc40-mt-1_38.dylib libboost_filesystem.dylib /opt/local/lib # cf EE
     ln -s libboost_system-xgcc40-mt-1_38.dylib     libboost_system.dylib     /opt/local/lib # cf EE 
     port install sqlite3              -y
     port install qt4-mac              -y
     ln -s qmake-mac qmake /opt/local/bin  # cf EED
     port install mesa                 -y
     ;;
  *)
     echo " '$OperatingSystem' : Unknown (for us...) Operating Sytem "
     echo " Allowed values are (right now) Fedora, Ubuntu, MacOS "
     exit 0
     ;;
  esac
fi
