#!/bin/bash
# creates the file architecture for a new project

if [ $# -lt 2 ]
    then
    echo "usage : creaNewProject <project-path> <project-name>" 
    exit
fi

# creaNewProject path
TMP=$(which $0|rev)
BINPATH=$(echo ${TMP#*/}|rev)
# Input data path
INPUT=${BINPATH}/../share/creaNewProject

OUTPUT=$1
PROJECT=$2

echo "output = " $OUTPUT
echo "bin    = " $BINPATH
echo "input  = " $INPUT
echo "project= " $PROJECT

if [ -d $OUTPUT/${PROJECT} ]
    then 
    echo "ERROR : Directory '$OUTPUT/${PROJECT}' already exists !"
    exit 1
fi

echo "** Creating new project '$PROJECT' in folder '$OUTPUT'"

if [ ! -d $OUTPUT ]
    then 
    echo "ERROR : Directory '$OUTPUT' does not exist !"
    exit 1
fi

cp -R ${INPUT} "$OUTPUT/$PROJECT"
cd $OUTPUT/$PROJECT

cat CMakeLists.txt.in | sed s,PROJECT_NAME,"${PROJECT}", > CMakeLists.txt
rm CMakeLists.txt.in

echo
echo "New Project created !" 
echo
echo "==>"
echo "==> Edit the file '$OUTPUT/${PROJECT}/CMakeLists.txt' to customize your project"
echo "==>"
echo
echo
