/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageImageConvolution_h_INCLUDED__
#define __bbPackRecalageImageConvolution_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"
#include "Convolution.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ImageConvolution
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageConvolution,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Factor,double);
  BBTK_DECLARE_INPUT(On,bool);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  Convolution* convolution;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageConvolution,bbtk::AtomicBlackBox);
BBTK_NAME("ImageConvolution");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Processes an image through different convolution matrix (Edge detect)");
BBTK_CATEGORY("filter");
BBTK_INPUT(ImageConvolution,In,"Image to be filetered",vtkImageData*,"");
BBTK_INPUT(ImageConvolution,Factor,"Factor by how the edges will be represented",double,"");
BBTK_INPUT(ImageConvolution,On,"Boolean that represents if the filter is turned on. True = On.",bool,"");
BBTK_OUTPUT(ImageConvolution,Out,"Filtered Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageConvolution);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageConvolution_h_INCLUDED__

