/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageImageRecalageProperties_h_INCLUDED__
#define __bbPackRecalageImageRecalageProperties_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT ImageRecalageProperties
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageRecalageProperties,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_OUTPUT(LengthX,int);
  BBTK_DECLARE_OUTPUT(LengthY,int);
  BBTK_DECLARE_OUTPUT(LengthZ,int);
  BBTK_DECLARE_OUTPUT(ColorLevel,int);
  BBTK_DECLARE_OUTPUT(MidColorLevel,int);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  vtkImageData *image;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageRecalageProperties,bbtk::AtomicBlackBox);
BBTK_NAME("ImageRecalageProperties");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Finds image properties necessary for image registration.");
BBTK_CATEGORY("image");
BBTK_INPUT(ImageRecalageProperties,In,"Image",vtkImageData*,"");
BBTK_OUTPUT(ImageRecalageProperties,LengthX,"Lenght in X",int,"");
BBTK_OUTPUT(ImageRecalageProperties,LengthY,"Lenght in Y",int,"");
BBTK_OUTPUT(ImageRecalageProperties,LengthZ,"Lenght in Z",int,"");
BBTK_OUTPUT(ImageRecalageProperties,ColorLevel,"ColorLevel/WindowLevel range of the Image",int,"");
BBTK_OUTPUT(ImageRecalageProperties,MidColorLevel,"Medium value of the ColorLevel/WindowLevel range of the Image",int,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageRecalageProperties);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageRecalageProperties_h_INCLUDED__

