/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageTransform3D2PointsBox_h_INCLUDED__
#define __bbPackRecalageTransform3D2PointsBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "Transformer3D.h"
#include "vtkLinearTransform.h"
#include "vtkMath.h"
#include "PlanesOperations.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT Transform3D2PointsBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(Transform3D2PointsBox,bbtk::AtomicBlackBox);

  /*Points in X*/
  BBTK_DECLARE_INPUT(InX1,std::vector<int>);

  /*Points in Y*/
  BBTK_DECLARE_INPUT(InY1,std::vector<int>);

  /*Points in Z*/
  BBTK_DECLARE_INPUT(InZ1,std::vector<int>);

  /*Points in X*/
  BBTK_DECLARE_INPUT(InX2,std::vector<int>);

  /*Points in Y*/
  BBTK_DECLARE_INPUT(InY2,std::vector<int>);

  /*Points in Z*/
  BBTK_DECLARE_INPUT(InZ2,std::vector<int>);

  /*Labels of points*/
  BBTK_DECLARE_INPUT(Labels1,std::vector<std::string>);
  /*Labels of points*/
  BBTK_DECLARE_INPUT(Labels2,std::vector<std::string>);

  /*Second angle*/
  BBTK_DECLARE_INPUT(SecondAngle,double);

  /*Resultant vtkTransform*/
  BBTK_DECLARE_OUTPUT(Out, vtkTransform*);
  
  BBTK_PROCESS(Process);
  void Process();

  /*Class in charge of making the transformations*/
  Transformer3D *transformer;

  /*Class that does the vector operations*/
  PlanesOperations *planes;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(Transform3D2PointsBox,bbtk::AtomicBlackBox);
BBTK_NAME("Transform3D2PointsBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Box useful for creating matrixes for 3D transformations defined by 2 points");
BBTK_CATEGORY("image");
BBTK_INPUT(Transform3D2PointsBox,InX1,"Points in X (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,InY1,"Points in Y (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,InZ1,"Points in Z (first image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,InX2,"Points in X (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,InY2,"Points in Y (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,InZ2,"Points in Z (second image)",std::vector<int>,"");
BBTK_INPUT(Transform3D2PointsBox,SecondAngle,"Rotation to be done in second axis",double,"");
BBTK_INPUT(Transform3D2PointsBox,Labels1,"Labels of the points (first image)",std::vector<std::string>,"");
BBTK_INPUT(Transform3D2PointsBox,Labels2,"Labels of the points (second image)",std::vector<std::string>,"");
BBTK_OUTPUT(Transform3D2PointsBox,Out,"Transformation Matrix",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(Transform3D2PointsBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageTransform3DBox_h_INCLUDED__

