/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuCutModule_h_INCLUDED__
#define __bbcreaMaracasVisuCutModule_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"
#include "CutModelMainPanel.h"

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT CutModule2
 : 
   public bbtk::WxBlackBox
{

  BBTK_BLACK_BOX_INTERFACE(CutModule2,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_INPUT(Interactor,vtkRenderWindowInteractor*);
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	CutModelMainPanel* _mainpanel;
	vtkImageData* _currentimage;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CutModule2,bbtk::WxBlackBox);
BBTK_NAME("CutModule2");
BBTK_AUTHOR("perez@creatis.insa-lyon.fr");
BBTK_DESCRIPTION("extracts");
BBTK_CATEGORY("actor, image, filter");
BBTK_INPUT(CutModule2,In,"Image",vtkImageData*,"");
BBTK_INPUT(CutModule2,Interactor,"WindowInteractor",vtkRenderWindowInteractor*,"");
BBTK_INPUT(CutModule2,Renderer,"Renderer",vtkRenderer*,"");
BBTK_OUTPUT(CutModule2,Out,"Image output",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(CutModule2);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuCutModule_h_INCLUDED__
#endif // _USE_WXWIDGETS_
