/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuSTL_h_INCLUDED__
#define __bbcreaMaracasVisuSTL_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"

//#include "marInterface.h"

namespace bbcreaMaracasVisu
{

class bbcreaMaracasVisu_EXPORT STL
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(STL,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(In, vtkImageData*);  
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	//marInterface* mar;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(STL, bbtk::WxBlackBox);
BBTK_NAME("STL");
BBTK_AUTHOR("car-prie@uniandes.edu.co");
BBTK_DESCRIPTION("Black Box from the module STL in Maracas");
BBTK_CATEGORY("image, widget");
BBTK_INPUT(STL, In, "Image to the STereoLithography", vtkImageData*, "");
BBTK_END_DESCRIBE_BLACK_BOX(STL);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuSTL_h_INCLUDED__
#endif // _USE_WXWIDGETS_

