/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
#ifndef __bbcreaMaracasVisuTubeTreeFilter_h_INCLUDED__
#define __bbcreaMaracasVisuTubeTreeFilter_h_INCLUDED__
#include "bbcreaMaracasVisu_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"


#include <vtkProp3D.h>
#include <vtkRenderer.h>
#include "vtkImageData.h"
#include "vtkActor.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkProperty.h"
#include "vtkLinearTransform.h"
#include "vtkLookupTable.h"
#include "vtkScalarsToColors.h"



class /*VTK_COMMON_EXPORT*/ vtkLookupTableEED : public vtkScalarsToColors
	{
	public:
		// Description:
		// Construct with range=[0,1]; and hsv ranges set up for rainbow color table 
		// (from red to blue).
		static vtkLookupTableEED *New();
		
		vtkTypeMacro(vtkLookupTableEED,vtkScalarsToColors);
		void PrintSelf(ostream& os, vtkIndent indent);
		
		double *GetRange() { return this->GetTableRange(); };
		void SetRange(double min, double max) { this->SetTableRange(min, max); };
		void SetRange(double rng[2]) { this->SetRange(rng[0], rng[1]); };
		
		void SetTableRange(double r[2]); 
		virtual void SetTableRange(double min, double max);
		vtkGetVectorMacro(TableRange,double,2);
		
		unsigned char *MapValue(double v);
		
		void GetColor(double x, double rgb[3]);
		
		void MapScalarsThroughTable2(void *input, unsigned char *output,
									 int inputDataType, int numberOfValues,
									 int inputIncrement, int outputIncrement);
		
		
	protected:
		
		double TableRange[2];
		vtkLookupTableEED(int sze=256, int ext=256);
		~vtkLookupTableEED();
		
		
	private:
		vtkLookupTableEED(const vtkLookupTableEED&);  // Not implemented.
		void operator=(const vtkLookupTableEED&);  // Not implemented.
};





namespace bbcreaMaracasVisu
{
	

class bbcreaMaracasVisu_EXPORT TubeTreeFilter
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TubeTreeFilter,bbtk::AtomicBlackBox);
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
	BBTK_DECLARE_INPUT(Renderer     , vtkRenderer*);
	BBTK_DECLARE_INPUT(lstIndexs    , std::vector<int>);
	BBTK_DECLARE_INPUT(lstPointX    , std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointY    , std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointZ    , std::vector<double>);
	BBTK_DECLARE_INPUT(lstRadio     , std::vector<double>);
	BBTK_DECLARE_INPUT(lstRadioLaw  , int);
	BBTK_DECLARE_INPUT(Colour       , std::vector<double>);
	BBTK_DECLARE_INPUT(ColourLaw    , int);
	BBTK_DECLARE_INPUT(Transform    , vtkLinearTransform *);
	BBTK_DECLARE_INPUT(Opacity      , double );
	BBTK_DECLARE_INPUT(iTube        , int );
	BBTK_DECLARE_OUTPUT(OutTube,vtkProp3D *);
	BBTK_PROCESS(Process);
  void Process();

  private:
	std::vector<vtkActor*>		vecVtkActors;
	std::vector< vtkDoubleArray* >  vecTubeRadiosArray;

	void DrawOneTube(int iGeneral,int numPoints, int iTube);
	void SetGraphicProperties();
	void SetRadioTube(int iGeneral,int numPoints, int iTube);
    int oldLstSize;

//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TubeTreeFilter,bbtk::AtomicBlackBox);
	BBTK_NAME("TubeTreeFilter");
	BBTK_AUTHOR("Info-Dev");
	BBTK_DESCRIPTION("vtk Tube Tree Filter");
	BBTK_CATEGORY("actor");

	BBTK_INPUT(TubeTreeFilter,Renderer,"Renderer",vtkRenderer*,"");
	BBTK_INPUT(TubeTreeFilter,lstIndexs,"Indexs",std::vector<int>,"");
	BBTK_INPUT(TubeTreeFilter,lstPointX,"lstPointX",std::vector<double>,"");
	BBTK_INPUT(TubeTreeFilter,lstPointY,"lstPointY",std::vector<double>,"");
	BBTK_INPUT(TubeTreeFilter,lstPointZ,"lstPointZ",std::vector<double>,"");
	BBTK_INPUT(TubeTreeFilter,lstRadio,"lstRadio (default 1) ",std::vector<double>,"");
	BBTK_INPUT(TubeTreeFilter,lstRadioLaw,"0(default) radio for all, 1 radio by segment, 2 radio by point",int,"");
	BBTK_INPUT(TubeTreeFilter,Colour,"Colour",std::vector<double>,"");
    	BBTK_INPUT(TubeTreeFilter,ColourLaw,"ColorLaw 1(default) solid color, 2 color by segment, 3 color for each point",int,"");
	BBTK_INPUT(TubeTreeFilter,Transform,"vtkTransform", vtkLinearTransform *,"");
	BBTK_INPUT(TubeTreeFilter,iTube,"iTube",int,"");
	BBTK_INPUT(TubeTreeFilter,Opacity,"Opacity",double,"");

	BBTK_OUTPUT(TubeTreeFilter,OutTube,"Tube[iTube]",vtkProp3D *,"");

BBTK_END_DESCRIBE_BLACK_BOX(TubeTreeFilter);
//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//=====
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuTubeTreeFilter_h_INCLUDED__

