/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __bbcreaMaracasVisuDrawAxisTree3D_h_INCLUDED__
#define __bbcreaMaracasVisuDrawAxisTree3D_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkProp3D.h>
#include <vtkRenderer.h>
#include "vtkImageData.h"
#include "vtkActor.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"
#include "vtkProperty.h"

namespace bbcreaMaracasVisu
{

class /*BBTK_EXPORT*/ DrawAxisTree3D
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(DrawAxisTree3D,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(Renderer   , vtkRenderer*);
  BBTK_DECLARE_INPUT(lstIndexs  , std::vector<int>);
  BBTK_DECLARE_INPUT(lstPointX  , std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointY  , std::vector<double>);
  BBTK_DECLARE_INPUT(lstPointZ  , std::vector<double>);
  BBTK_DECLARE_INPUT(lstRadio   , std::vector<double>);
  BBTK_DECLARE_INPUT(ColourLaw  , int );
  BBTK_DECLARE_INPUT(Colour     , std::vector<double>);
  BBTK_DECLARE_INPUT(Transform  , vtkLinearTransform *);
  BBTK_DECLARE_INPUT(Opacity    , double);
  BBTK_DECLARE_INPUT(LineWidth   , double);
  BBTK_DECLARE_INPUT(iAxis, int );
  BBTK_DECLARE_OUTPUT(OutAxis,vtkProp3D *);
  BBTK_PROCESS(Process);
  void Process();

private:

    int oldLstSize;
	std::vector<vtkPolyData*>	vecVtkPolyData;
	std::vector<vtkPolyDataMapper*>	vecVtkPolyDataMaper;
	std::vector<vtkActor*>		vecVtkActors;

	void DrawOneAxis(int iGeneral,int numPoints, int iAxis);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(DrawAxisTree3D,bbtk::AtomicBlackBox);
BBTK_NAME("DrawAxisTree3D");
BBTK_AUTHOR("InfoTeam CREATIS-LRMN");
BBTK_DESCRIPTION("Draw Axis Tree 3D");
BBTK_CATEGORY("actor");
  BBTK_INPUT(DrawAxisTree3D,Renderer,"Renderer",vtkRenderer*,"");
  BBTK_INPUT(DrawAxisTree3D,lstIndexs,"Indexs",std::vector<int>,"");
  BBTK_INPUT(DrawAxisTree3D,lstPointX,"lstPointX",std::vector<double>,"");
  BBTK_INPUT(DrawAxisTree3D,lstPointY,"lstPointY",std::vector<double>,"");
  BBTK_INPUT(DrawAxisTree3D,lstPointZ,"lstPointZ",std::vector<double>,"");
  BBTK_INPUT(DrawAxisTree3D,lstRadio,"lstRadio",std::vector<double>,"");
  BBTK_INPUT(DrawAxisTree3D,Colour,"Colour  R1 G1 B1 R2 G2 B2 ...  range[0..1]",std::vector<double>,"");
  BBTK_INPUT(DrawAxisTree3D,ColourLaw,"ColorLaw 1(default) solid color, 2 color by segment (random if is necessary) , 3 color for each point",int,"");
  BBTK_INPUT(DrawAxisTree3D,Transform,"vtkTransform", vtkLinearTransform *,"");
  BBTK_INPUT(DrawAxisTree3D,Opacity,"Opacity",double,"");
  BBTK_INPUT(DrawAxisTree3D,LineWidth,"LineWidth (default 0.5)",double,"");
  BBTK_INPUT(DrawAxisTree3D,iAxis,"iAxis",int,"");
  BBTK_OUTPUT(DrawAxisTree3D,OutAxis,"Axis[iAxis]",vtkProp3D *,"");
BBTK_END_DESCRIBE_BLACK_BOX(DrawAxisTree3D);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuDrawAxisTree3D_h_INCLUDED__

