/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#define __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#include "bbtkWxBlackBox.h"
#include <cmath>

#include "vtkActor.h"
#include "vtkSphereSource.h"
#include "vtkImageData.h"
#include "vtkRenderer.h"
#include "vtkTextActor3D.h"

namespace bbcreaMaracasVisu
{

  class ShowNPoints;

  //--------------------------------------------------------------------------
  class WidgetShowNPoints : public wxPanel
  {
  public:
	  WidgetShowNPoints( wxWindow *parent,  ShowNPoints *box);
	  ~WidgetShowNPoints(); 
	  void OnAddPoint(wxCommandEvent &event);   
		void OnInsertPoint (wxCommandEvent& event);//CFT
	  void OnSetPoint(wxCommandEvent& event);
	  void OnRenamePoint(wxCommandEvent& event);
	  void OnErasePoint(wxCommandEvent& event);
	  void OnEraseLastPoint(wxCommandEvent &event);   
	  void OnDeleteAllPoints(wxCommandEvent &event);   
	  void OnSavePoints(wxCommandEvent &event);   
	  void OnLoadPoints(wxCommandEvent &event);
	  void UpdatePoints(wxCommandEvent &event);
	  
	  void RefreshPoint(int id);
	  
	  void SetPoint(std::vector<int> ppoint);
	  void SetColour(std::vector<double> colour);
	  void SetOpacity(double opacity);
	  void SetRadio(double radio);
	  void SetImage(vtkImageData *image);
	  void SetRenderer(vtkRenderer *renderer);
	  std::vector<int> GetLstPointsX();
	  std::vector<int> GetLstPointsY();
	  std::vector<int> GetLstPointsZ();
	  std::vector<std::string> GetLstLabels();

	  void AddPoint(int x, int y, int z, std::string label);
		void InsertPoint(int x, int y, int z, std::string label);//CFT
		double Distance(double dX0, double dY0, double dZ0, double dX1, double dY1, double dZ1);//CFT

  private:

	  std::string           CleanSpaces(std::string ss);
	  int                   GetNearestPoint();
	  int					IdInsidePoint();
	  void                  ErasePoint(int id);
	  void                  SetOutputBox();

	  ShowNPoints                   *mbbShowNPoints;
	  vtkRenderer                   *renderer;
	  std::vector<int>              lstPointsX;
	  std::vector<int>              lstPointsY;
	  std::vector<int>              lstPointsZ;
	  std::vector<std::string>      lstLabels;
	  std::vector<vtkActor*>        lstActorsSphere;//NTU changed from prop3D to Actor
	  std::vector<vtkTextActor3D*>  lstActorsText;

	  //NTU: For updating points

	  std::vector<vtkSphereSource*> lstSourceSphere;

	  std::vector<int>      mpoint;
	  vtkImageData          *mimage;
	  std::vector<double>   mcolour;
	  double                mopacity;
	  double                mradio;
	  wxStaticText          *askPointLabel;
	  wxTextCtrl            *textCtrl;
	  wxStaticText          *txtNrPoints;
	  wxSlider              *sdrOpacity;
	  wxSlider              *sdrRadio;

  };

class /*BBTK_EXPORT*/ ShowNPoints
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ShowNPoints,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(In, std::vector<int> );
  BBTK_DECLARE_INPUT(Renderer, vtkRenderer* );
  BBTK_DECLARE_INPUT(Image, vtkImageData* );
  BBTK_DECLARE_INPUT(Colour, std::vector<double> );
  BBTK_DECLARE_INPUT(Opacity, double );
  BBTK_DECLARE_INPUT(Radio, double );
  BBTK_DECLARE_INPUT(Type, int );
  BBTK_DECLARE_OUTPUT( lstPointsX, std::vector<int> );
  BBTK_DECLARE_OUTPUT( lstPointsY, std::vector<int> );
  BBTK_DECLARE_OUTPUT( lstPointsZ, std::vector<int> );
  BBTK_DECLARE_OUTPUT( lstLabels,  std::vector<std::string> );
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

private:
	WidgetShowNPoints *mwxwidget; 
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ShowNPoints,bbtk::WxBlackBox);
  BBTK_NAME("ShowNPoints");
  BBTK_AUTHOR("Eduardo DAVILA");
  BBTK_DESCRIPTION("widget that shows N moints in 3D (vtkActors)");
  BBTK_CATEGORY("widgetVtk");
  BBTK_INPUT(ShowNPoints,In,"One Point",std::vector<int>,"");
  BBTK_INPUT(ShowNPoints,Renderer,"Renderer",vtkRenderer*,"");
  BBTK_INPUT(ShowNPoints,Image,"vktkImageData",vtkImageData*,"");
  BBTK_INPUT(ShowNPoints,Colour,"Colour of the actor",std::vector<double>,"colour");
  BBTK_INPUT(ShowNPoints,Opacity,"Opacity of the actor 0..1 (default 1)",double,"");
  BBTK_INPUT(ShowNPoints,Radio,"Radio of the spheres 1..50 (default 10)",double,"");
  BBTK_INPUT(ShowNPoints,Type,"Type of the widget. 0(default): N-points, 1:Just one point",int,"");
  BBTK_OUTPUT(ShowNPoints , lstPointsX , " list of points X ", std::vector<int> ,"");
  BBTK_OUTPUT(ShowNPoints , lstPointsY , " list of points Y ", std::vector<int> ,"");
  BBTK_OUTPUT(ShowNPoints , lstPointsZ , " list of points Z ", std::vector<int> ,"");
  BBTK_OUTPUT(ShowNPoints , lstLabels , " list of labels ", std::vector<std::string> ,"");
BBTK_END_DESCRIBE_BLACK_BOX(ShowNPoints);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuShowNPoints_h_INCLUDED__
#endif // _USE_WXWIDGETS_
