/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuTransferFunctionView_h_INCLUDED__
#define __bbcreaMaracasVisuTransferFunctionView_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"
//#include "HistogramWidget.h"
#include "HistogramDialogComboBox.h"

#include "vtkPiecewiseFunction.h"
#include "vtkColorTransferFunction.h"
#include <wx/wx.h>

namespace bbcreaMaracasVisu
{

  

class /*BBTK_EXPORT*/ TransferFunctionView
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(TransferFunctionView,bbtk::WxBlackBox);
	BBTK_DECLARE_INPUT(In, vtkImageData*);
	BBTK_DECLARE_OUTPUT(OpacityFunction, vtkPiecewiseFunction*);
	BBTK_DECLARE_OUTPUT(ColorFunction, vtkColorTransferFunction*);

	BBTK_DECLARE_OUTPUT(WindowLevel, double);
	BBTK_DECLARE_OUTPUT(ColorLevel, double);
	/*BBTK_DECLARE_OUTPUT(GreyLevel, std::vector<double> );
	BBTK_DECLARE_OUTPUT(Value, std::vector<double> );
	BBTK_DECLARE_OUTPUT(GreyLevelColors, std::vector<double>);
	BBTK_DECLARE_OUTPUT(Red, std::vector<double>);
	BBTK_DECLARE_OUTPUT(Green, std::vector<double>);
	BBTK_DECLARE_OUTPUT(Blue, std::vector<double>);*/

  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow* parent);  

  void onColorChange();

  void onSliderChange();

  private:
	//HistogramWidget *mwxwidget;
	  HistogramDialogComboBox *mwxwidget;
	vtkImageData* _currentimg;
	
	vtkPiecewiseFunction* _tfun;
	vtkColorTransferFunction* _ctfun;
};

class HandlerTransferFunctionView : public wxEvtHandler
{
	public:
		HandlerTransferFunctionView(TransferFunctionView* box);
		~HandlerTransferFunctionView();    
		
		 void onColorChange(wxCommandEvent& event);

		 void onSliderChange(wxCommandEvent& event);
		
	private:
		TransferFunctionView			*_box;	
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(TransferFunctionView,bbtk::WxBlackBox);
BBTK_NAME("TransferFunctionView");
BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
BBTK_DESCRIPTION("Transfer Function Window");
//BBTK_CATEGORY("__CategoryBlackBox__");
  BBTK_INPUT(TransferFunctionView,In,"Input image",vtkImageData*,"");
	BBTK_OUTPUT(TransferFunctionView,OpacityFunction,"Transfer function for the opacity", vtkPiecewiseFunction*,"");
	BBTK_OUTPUT(TransferFunctionView,ColorFunction,"Transfer function for the color", vtkColorTransferFunction*,"");  
	BBTK_OUTPUT(TransferFunctionView,WindowLevel,"WidowLevel for the current window", double,"");  
	BBTK_OUTPUT(TransferFunctionView,ColorLevel,"ColorLevel for the current window", double,"");  
  /*BBTK_OUTPUT(TransferFunctionView,GreyLevel,"Greylevel related to the transparency",std::vector<double>,"");
  BBTK_OUTPUT(TransferFunctionView,Value,"Value of the transparency in the transfer function",std::vector<double>,"");
  BBTK_OUTPUT(TransferFunctionView,GreyLevelColors,"Grey level of the color in the transfer function",std::vector<double>,"");
  BBTK_OUTPUT(TransferFunctionView,Red,"Red value according to the GreyLevelColors",std::vector<double>,"");
  BBTK_OUTPUT(TransferFunctionView,Green,"Green value according to the GreyLevelColors",std::vector<double>,"");
  BBTK_OUTPUT(TransferFunctionView,Blue,"Blue value according to the GreyLevelColors",std::vector<double>,"");*/
BBTK_END_DESCRIBE_BLACK_BOX(TransferFunctionView);
}


// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuTransferFunctionView_h_INCLUDED__
#endif // _USE_WXWIDGETS_

