/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifdef _USE_WXWIDGETS_
#ifndef __bbcreaMaracasVisuViewerMPR_h_INCLUDED__
#define __bbcreaMaracasVisuViewerMPR_h_INCLUDED__
#include "bbtkWxBlackBox.h"

#include "wxMaracasMPR.h"
#include "vtkImageData.h"
#include "vtkRenderer.h"
#include "wxMPRWidget2.h"

namespace bbcreaMaracasVisu
{



  //--------------------------------------------------------------------------
  class ViewerMPR;
  class wxWidgetMPR : public wxPanel
  {
	public:
		wxWidgetMPR(ViewerMPR* box,wxWindow* parent, marImageData	*marimagedata=NULL);
		~wxWidgetMPR();
	    
		//if the MPR had generated the refresh event
		void OnRefreshView(wxCommandEvent & event);
		void OnDClickLeft(wxCommandEvent & event); 

		//Get the actual Point
		std::vector <int> GetPoint();
		//Get renderer
		vtkRenderer* GetRenderer();

		//refreshView
		void Refresh();

		void setImageData(vtkImageData* img);
		void ConfigureVTK();
		
	private:
		
		ViewerMPR			*mbbViewerMPR;
		wxMPRWidget2		*wxwidget;
		std::vector<int>	point;
			
	DECLARE_EVENT_TABLE( );
	    
  };
  
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------



class /*BBTK_EXPORT*/ ViewerMPR
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ViewerMPR,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(In, vtkImageData *);
    BBTK_DECLARE_OUTPUT(Renderer,vtkRenderer *);
	BBTK_DECLARE_OUTPUT(Point,std::vector<int>);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow* parent);

private:
  wxWidgetMPR *wxwidget;
  vtkImageData	*_img;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ViewerMPR,bbtk::WxBlackBox);
	BBTK_NAME("ViewerMPR");
	BBTK_AUTHOR("eduardo.davila [at] creatis.insa-lyon.fr");
	BBTK_DESCRIPTION("Maracas viewer MPR + 3D");
    BBTK_CATEGORY("viewer");
    BBTK_INPUT(ViewerMPR,Title,"Viewer MPR + 3D",std::string,"");
	BBTK_INPUT(ViewerMPR,In,"Input image",vtkImageData*,"");
	BBTK_OUTPUT(ViewerMPR,Renderer," This object accept actors of vtk type (ex. AddActor). ",vtkRenderer*,"");
	BBTK_OUTPUT(ViewerMPR,Point," This is the point choose by the user ",std::vector<int>,"");

BBTK_END_DESCRIBE_BLACK_BOX(ViewerMPR);
}
// EO namespace bbcreaMaracasVisu

#endif // __bbcreaMaracasVisuViewerMPR_h_INCLUDED__
#endif // _USE_WXWIDGETS_

