/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkExtractImageFilter.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.11 $
=========================================================================*/
                                                                     


#ifdef _USE_ITK_

#include "bbtkAtomicBlackBox.h"
#include "itkExtractImageFilter.h"
#include "bbtkItkBlackBoxMacros.h"
#include "bbitkImage.h"
#include "bbitkImageRegion.h"

namespace bbitk
{

  //===================================================
  /// Template filter
  template <class T>
  class /*BBTK_EXPORT*/ ExtractImageFilter
    : 
    public bbtk::AtomicBlackBox,
    public itk::ExtractImageFilter<T,T>
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(ExtractImageFilter,
				      bbtk::AtomicBlackBox,
				      T);
    typedef itk::ExtractImageFilter<T,T> itkParent;

    BBTK_DECLARE_ITK_INPUT(In,const T*);
    BBTK_DECLARE_ITK_PARAM(ExtractionRegion,typename T::RegionType);
    BBTK_DECLARE_ITK_OUTPUT(Out,T*);

    BBTK_ITK_PROCESS();
    BBTK_ITK_DELETE();
  };
  //===================================================


  //===================================================
  // Descriptor of template filter 
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(ExtractImageFilter,
				      bbtk::AtomicBlackBox);
  BBTK_NAME("ExtractImageFilter<"+bbtk::TypeName<T>()+">");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Decrease the image size by cropping the image to the selected region bounds (bbification of itk::ExtractImageFilter)");
  BBTK_TEMPLATE_INPUT(ExtractImageFilter,In,"Input image",const T*);
  BBTK_TEMPLATE_INPUT(ExtractImageFilter,ExtractionRegion,"Extraction region",typename T::RegionType);
  BBTK_TEMPLATE_OUTPUT(ExtractImageFilter,Out,"Output image",T*);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(ExtractImageFilter);
  //===================================================

  //===================================================
  template <class T> void ExtractImageFilter<T>::bbUserSetDefaultValues() {}
  template <class T> void ExtractImageFilter<T>::bbUserInitializeProcessing(){}
  template <class T> void ExtractImageFilter<T>::bbUserFinalizeProcessing() {}
  //===================================================
  








  //===================================================
  // Generic "untemplatized" filter
  //===================================================
  class /*BBTK_EXPORT*/ ExtractImageFilterGeneric
    : public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(ExtractImageFilterGeneric,
			     bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_DECLARE_INPUT(Region,anyImageRegion);
    BBTK_DECLARE_OUTPUT(Out,anyImagePointer);
    BBTK_PROCESS(ProcessSwitch);
  private :
    void ProcessSwitch();
    template <class T> void Process();
  };
  //===================================================
  
  //===================================================
  // Descriptor of generic filter
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ExtractImageFilterGeneric,
				bbtk::AtomicBlackBox);
  BBTK_NAME("ExtractImageFilter");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_CATEGORY("image;filter");
  BBTK_DESCRIPTION("Decrease the image size by cropping the image to the selected region bounds (bbification of itk::ExtractImageFilter)");
  BBTK_INPUT(ExtractImageFilterGeneric,In,"Input image",anyImagePointer,"");
  BBTK_INPUT(ExtractImageFilterGeneric,Region,"Extraction region",anyImageRegion,"");
  BBTK_OUTPUT(ExtractImageFilterGeneric,Out,"Output image",anyImagePointer,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ExtractImageFilterGeneric);
  //===================================================


  //===================================================
  // The main processing method is template on the itk image type 
  // which was set to the input. 
  // It is called by the ProcessSwitch method which checks the input In type
  // and calls Process<T> where T is the right type.
  template <class T>
  void ExtractImageFilterGeneric::Process()
  {
    bbtkDebugMessageInc("Core",9,
			"bbitk::ExtractImageFilterGeneric::Process<"
			<<bbtk::TypeName<T>()<<">()"<<std::endl);
    // T is the type of input image
    typedef T ImageType;
    // We define the type of the filter to use which is template 
    // on the image type
    typedef ExtractImageFilter<ImageType> FilterType;
    // Allocate the filter
    typename FilterType::Pointer f = FilterType::New("Temp");

    // Set the input In of the filter
    // Here we :
    // 1) Get **OUR** input 'In' by bbGetInputIn()
    //    It is a anyImagePointer
    // 2) We **KNOW** that the actual type stored by the anyImagePointer
    //    is ImageType* hence we get the value stored using the 
    //    unsafe_get method (which is a template method on the return type)
    f->bbSetInputIn( this->bbGetInputIn().unsafe_get<ImageType*>() );
    
    // The same for the ImageRegion except that we use 'get' and not 
    // 'unsafe get' because the region dimension passed by the user may not be 
    // compatible with the image dimension.
    // If get fails it throws an exception which must be caught outside 
    f->bbSetInputExtractionRegion ( this->bbGetInputRegion().get<typename T::RegionType>() );

    // Execute the filter
    f->bbExecute();
    // Register its output or it will be deleted we delete the filter
    f->bbGetOutputOut()->Register();
    // Set OUR output
    this->bbSetOutputOut( f->bbGetOutputOut() );
    // Delete the temporary filter
    f->bbDelete();

    bbtkDebugDecTab("Core",9);
  }
  //===================================================

}
// EO namespace bbitk

#endif 
