/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageStatistics.h,v $
  Language:  C++
  Date:      $Date: 2013/03/27 $
  Version:   $Revision: 1.0 $
  Modified by: Ricardo A Corredor (RaC)
=========================================================================*/


/**
 * \file
 * \brief class ITKImageStatistics : generic ITKImage statistics
 */
/**
 * \class bbtk::ITKImageStatistics
 * \brief Generic ITKImage statictis
 */

#ifdef _USE_ITK_
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#ifndef __bbitkImageStatistics_h_INCLUDED__
#define __bbitkImageStatistics_h_INCLUDED__
//#include "bbitk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"

#include "iostream"

#include "bbitkImage.h"

#include <itkStatisticsImageFilter.h>


namespace bbitk
{

class /*bbitk_EXPORT*/ ImageStatistics
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageStatistics,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
  BBTK_DECLARE_INPUT(In,bbitk::anyImagePointer);
  BBTK_DECLARE_OUTPUT(Min,double);
  BBTK_DECLARE_OUTPUT(Max,double);
  BBTK_DECLARE_OUTPUT(Mean,double);
  BBTK_DECLARE_OUTPUT(StdDev,double);
  BBTK_PROCESS(Process);
private:
  inline void Process();
  template <class T> void ProcessTemplated();
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageStatistics,bbtk::AtomicBlackBox);
BBTK_NAME("ImageStatistics");
BBTK_AUTHOR("Ricardo A Corredor");
BBTK_DESCRIPTION("Basic Image Statistics (minimim, maximum, mean, standard deviation)");
BBTK_CATEGORY("");
BBTK_INPUT(ImageStatistics,In,"Input image. Can be any itk::Image<T,D>*",bbitk::anyImagePointer,"");
BBTK_OUTPUT(ImageStatistics,Min,"Image minimum",double,"");
BBTK_OUTPUT(ImageStatistics,Max,"Image maximum",double,"");
BBTK_OUTPUT(ImageStatistics,Mean,"Image mean",double,"");
BBTK_OUTPUT(ImageStatistics,StdDev,"Image standard deviation",double,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageStatistics);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 


//===================================================
void ImageStatistics::Process()
{
	bbtk::TypeInfo t = bbGetInputIn().type();
	BBTK_TEMPLATE_ITK_IMAGE_SWITCH(t, this->ProcessTemplated);
}
//===================================================


//===================================================
template <class ImageType>
void ImageStatistics::ProcessTemplated()
{
	bbtkDebugMessageInc("Core",9,"bbitk::ImageStatistics::Process<"<<bbtk::TypeName<ImageType>()<<">()"<<std::endl);

	typedef itk::StatisticsImageFilter<ImageType> StatisticsImageFilterType;
	typename StatisticsImageFilterType::Pointer statisticsImageFilter = StatisticsImageFilterType::New ();

	// Input
	ImageType* in = this->bbGetInputIn().get<ImageType*>();

	statisticsImageFilter->SetInput(in);
	statisticsImageFilter->Update();

	std::cout << "Mean: " << statisticsImageFilter->GetMean() << std::endl;
	std::cout << "Std.: " << statisticsImageFilter->GetSigma() << std::endl;
	std::cout << "Min: " << statisticsImageFilter->GetMinimum() << std::endl;
	std::cout << "Max: " << statisticsImageFilter->GetMaximum() << std::endl;

	bbSetOutputMin((double)statisticsImageFilter->GetMinimum());
	bbSetOutputMax((double)statisticsImageFilter->GetMaximum());
	bbSetOutputMean((double)statisticsImageFilter->GetMean());
	bbSetOutputStdDev((double)statisticsImageFilter->GetSigma());

	bbtkDebugDecTab("Core",9);
}
//===================================================

}
// EO namespace bbitk

#endif // __bbitkImageStatistics_h_INCLUDED__

#endif  // _USE_ITK_
