/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkTypedImageToAnyImage.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.9 $
=========================================================================*/




#ifdef _USE_ITK_

#ifndef __bbTypedItkImage2GenericItkImage_h__
#define __bbTypedItkImage2GenericItkImage_h__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"
#include "bbtkSystem.h"

namespace bbitk 
{

  //=================================================================
  // BlackBox declaration
  template <class itkImageTypePointer>
  class TypedImageToAnyImage : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(TypedImageToAnyImage,
				      bbtk::AtomicBlackBox,
				      itkImageTypePointer);
    BBTK_DECLARE_INPUT(In,itkImageTypePointer);
    BBTK_DECLARE_OUTPUT(Out,anyImagePointer);
    BBTK_PROCESS(DoIt);
    void DoIt() { bbSetOutputOut( bbGetInputIn() ); bbGetInputIn()->Register(); }
  };
  //=================================================================
 
  //===================================================
  template <class T> void TypedImageToAnyImage<T>::bbUserSetDefaultValues()
  {}
  template <class T> void TypedImageToAnyImage<T>::bbUserInitializeProcessing()
  {}
  template <class T> void TypedImageToAnyImage<T>::bbUserFinalizeProcessing() 
  {}
  //===================================================
  

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(TypedImageToAnyImage,
				      bbtk::AtomicBlackBox);
  BBTK_NAME(bbtk::HumanTypeName<T>()
	    + "To" + bbtk::HumanTypeName<anyImagePointer>());
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Converts a typed itk image pointer ("
		   +bbtk::HumanTypeName<T>()+
		   ") into a generic itk image pointer ("+
		   bbtk::HumanTypeName<anyImagePointer>()+")");
  BBTK_CATEGORY("adaptor");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_TEMPLATE_INPUT(TypedImageToAnyImage,In,
		      "Input typed image",T);
  BBTK_TEMPLATE_OUTPUT(TypedImageToAnyImage,Out,
		       "Output generic image",anyImagePointer);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(TypedImageToAnyImage);
  //=================================================================

 

}
#endif
#endif
