/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdASCII.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.11 $
=========================================================================*/


#ifndef __bbstdASCII_h_INCLUDED__
#define __bbstdASCII_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"
#include "iostream"

namespace bbstd
{

  class bbstd_EXPORT ASCII
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(ASCII,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_DECLARE_INPUT(Type,int);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(Process);
    void Process();
  };
  
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ASCII,bbtk::AtomicBlackBox);
  BBTK_NAME("ASCII");  
  BBTK_AUTHOR("eduardo.davila [at] creatis [dot] insa-lyon.fr");

  BBTK_DESCRIPTION("ascii codes sequence to string - string to ascii codes sequence");
  BBTK_CATEGORY("misc");
  BBTK_INPUT(ASCII,In,   "Ascii code or Ascii character",                                               std::string,"");
  BBTK_INPUT(ASCII,Type, "Conversion type (default 0) 0=Ascii codes to string, 1=String to ascii codes",int,"");
  BBTK_OUTPUT(ASCII,Out, "Ascii codes sequence or characters sequence",                                 std::string,"");
  BBTK_END_DESCRIBE_BLACK_BOX(ASCII);

}
// EO namespace bbstd

#endif // __bbstdASCII_h_INCLUDED__

