/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdVectorToString.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.10 $
=========================================================================*/

#ifndef __bbstdVectorToString_INCLUDED_h__
#define __bbstdVectorToString_INCLUDED_h__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=================================================================
  // BlackBox declaration
  template <class T>
  class bbstd_EXPORT VectorToString : public bbtk::AtomicBlackBox
  {  
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(VectorToString,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,std::vector<T>);
    BBTK_DECLARE_INPUT(Separator,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(DoIt);
    void DoIt(); 
  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(VectorToString,bbtk::AtomicBlackBox);
  BBTK_NAME(bbtk::HumanTypeName<std::vector<T> >()+"ToString");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DEFAULT_ADAPTOR();
  BBTK_DESCRIPTION("Converts the content of the input vector ("+bbtk::TypeName<std::vector<T> >()+") to a string in which each item is separated by the value of the input 'Separator'");
  typedef std::vector<T> Tvector;
  BBTK_TEMPLATE_INPUT(VectorToString, In,"Input",Tvector);
  BBTK_TEMPLATE_INPUT(VectorToString, Separator,"Separator of item in the output string. Default is whitespace.",std::string);
  BBTK_TEMPLATE_OUTPUT(VectorToString, Out,"Output",std::string);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(VectorToString);
  //=================================================================

 //=================================================================
  template <class T>
  void VectorToString<T>::DoIt()
  {
    std::string out;
    typename std::vector<T>::const_iterator i;
    for (i=bbmInputIn.begin();i!=bbmInputIn.end();++i)
    {
      if (i!=bbmInputIn.begin())
         out += bbGetInputSeparator();
      std::ostringstream s;
      s <<  *i;
      out += s.str();
    }
    bbSetOutputOut(out);
  }
  //=================================================================

  //=================================================================  
  template <class T>
  void VectorToString<T>::bbUserSetDefaultValues()
  {
    bbSetInputSeparator(" ");
  }
  //=================================================================
  template <class T>
  void VectorToString<T>::bbUserInitializeProcessing() 
  { 
  }
  //=================================================================
  template <class T>
  void VectorToString<T>::bbUserFinalizeProcessing() 
  {
  }
  //=================================================================
} // namespace bbstd

#endif //__bbstdVectorToString_INCLUDED_h__

