/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkComplexBlackBoxDescriptor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
=========================================================================*/


/**
 *  \file 
 *  \brief Class bbtk::ComplexBlackBoxDescriptor : describes a ComplexBlackBox (constituents, connections) and is able to create an instance of it.
 */
/**
 * \class bbtk::ComplexBlackBoxDescriptor
 * \brief Describes a ComplexBlackBox (constituents, connections) and is able to create an instance of it.
 */

#ifndef __bbtkComplexBlackBoxDescriptor_h__
#define __bbtkComplexBlackBoxDescriptor_h__

#include "bbtkBlackBoxDescriptor.h"
#include "bbtkComplexBlackBoxInputDescriptor.h"
#include "bbtkComplexBlackBoxOutputDescriptor.h"
#include "bbtkFactory.h"
#include <fstream>
#include <vector>
#include "bbtkUtilities.h"
namespace bbtk
{

  class ComplexBlackBox;
  typedef boost::shared_ptr<ComplexBlackBox> ComplexBlackBoxPointer;

  //==========================================================================
  class BBTK_EXPORT ComplexBlackBoxDescriptor : 
    public bbtk::BlackBoxDescriptor
  {
    BBTK_OBJECT_INTERFACE(ComplexBlackBoxDescriptor);
    typedef BlackBoxDescriptor Superclass;
  public:
    friend class ComplexBlackBox;

    static Pointer New(const std::string& name); 
    /// Sets the factory used 
    void SetFactory(Factory::Pointer f) { mFactory = f; }
    /// Gets the factory used
    Factory::Pointer GetFactory() const { return mFactory.lock(); }

    /// Releases the descriptor
    //    void Release(bool release_package = true);

    /// Gets the factory used (const)
    //    const Factory* GetFactory() const { return mFactory; }

    /// Creates an instance of name <name> of the ComplexBlackBox of which this is the descriptor 
    virtual BlackBoxPointer NewBlackBox(const std::string& name);

    /// Adds a black box to the complex box
    /// Needs a factory set !
    void Add ( const std::string& type,
	       const std::string& name
	       ); 

    /// Removes a black box from the complex box
    void Remove( const std::string& name, bool remove_connections = true);

    /// Connects two black boxes of the complex box
    /// Needs a factory set !
     void Connect ( const std::string& from,
		   const std::string& output,
		   const std::string& to,
		   const std::string& input
		   ); 
    /// Defines an input of the complex box
    void DefineInput ( const std::string& name,
		       const std::string& box,
		       const std::string& input,
		       const std::string& help);
    /// Defines an output of the complex box
    void DefineOutput ( const std::string& name,
		       const std::string& box,
		       const std::string& output,
		       const std::string& help);
 
 
   
    /// 
    void AddToExecutionList( const std::string& box );

    ComplexBlackBoxPointer GetPrototype() { return mPrototype; }
    void PrintBlackBoxes(); 
   
    /// Prints help on the black box
    void GetHelp(bool full=true) const;
 
    /// Writes html formatted help into the output file stream. 
    /// detail and level are used for graphical representation of 
    /// complex black boxes (see ComplexBlackBox::InsertHTMLGraph)
    /// output_dir is the directory in which to write auxilliary files 
    /// (.dot/.png/.cmap)
    void InsertHtmlHelp ( std::ofstream& s, 
			  int detail, int level,
			  const std::string& output_dir = "",
			  bool relative_link = false);

    /// Generates a png image representing the pipeline graph of the 
    /// complex box and writes html code to insert it 
    /// into the output file stream. 
    /// detail : 
    /// level : depth of nested complex boxes graph development 
    /// (0:only this box level 
    /// output_dir is the directory in which to write the files 
    /// (.dot/.png/.cmap)
    void InsertHTMLGraph( std::ofstream& s, 
			  int detail, int level, 
			  const std::string& output_dir = "",
			  bool relative_link = false );
    
		void GetBoxesInside (NodeTreeC& tree, int cont);
   ///
    virtual void Check(bool recursive=true) const;
       


  protected:
    /// Default ctor with name is protected
    ComplexBlackBoxDescriptor(const std::string& name); 

  private:
	
    /// The factory used
    Factory::WeakPointer mFactory;
    /// The complex box in which boxes and connections are stored
    ComplexBlackBoxPointer mPrototype;
	      
  };
  // class ComplexBlackBoxDescriptor
  //==========================================================================


}
// namespace bbtk
#endif
