/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkItkBlackBoxMacros.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
=========================================================================*/





/**
 *  \file 
 *  \brief Defines macros for the creation of itk object inherited black boxes
 */
#ifndef __bbtkItkBlackBoxMacros_h__
#define __bbtkItkBlackBoxMacros_h__
//===========================================================================
//============================================================================
// ITK Specific macros
//===========================================================================
//===========================================================================

//===========================================================================
#define BBTK_ITK_DELETE()						\
  int bbDelete() {							\
    int refs = itkParent::GetReferenceCount()-1;			\
    itkParent::UnRegister();						\
    return refs;							\
  }
//===========================================================================

//===========================================================================
#define BBTK_ITK_BLACK_BOX_INTERFACE(CLASS,PARENTBLACKBOX,ITKPARENT)	\
  BBTK_BLACK_BOX_INTERFACE(CLASS,PARENTBLACKBOX);			\
  typedef ITKPARENT itkParent;						\
  BBTK_ITK_DELETE();
//===========================================================================

//===========================================================================
/// Declares an itk-inherited AtomicBlackBox input 
#define BBTK_DECLARE_ITK_INPUT(NAME,TYPE)				\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { return itkParent::GetInput(); }					\
  void bbSetInput##NAME (TYPE d)					\
  { itkParent::SetInput(d);						\
    /*bbSetModifiedStatus();*/ }						       
//===========================================================================

//===========================================================================
#define BBTK_DECLARE_ITK_OUTPUT(NAME,TYPE)			\
  public:								\
  TYPE bbGetOutput##NAME ()						\
  { return itkParent::GetOutput(); }					\
  void bbSetOutput##NAME (TYPE d)					\
  { /*PARENT::GetOutput() = d;*/ }					
//===========================================================================

//===========================================================================
/// Declares an AtomicBlackBox input corresponding to an inherited itk parameter
/// which was declared by itkSetMacro/itkGetMacro
/// The NAME **MUST** be the same than the itk parameter name
#define BBTK_DECLARE_ITK_PARAM(NAME,TYPE)			\
  public:								\
  TYPE bbGetInput##NAME ()						\
  { return itkParent::Get##NAME(); }					\
  void bbSetInput##NAME (TYPE d)					\
  { itkParent::Set##NAME(d);						\
    /*bbSetModifiedStatus();*/ }
//===========================================================================

//============================================================================
/// Defines the default bbUserProcess method for itk inherited black boxes
/// (calls itkParent::Update)
#define BBTK_ITK_PROCESS()						\
  public:								\
  inline void bbUserProcess()						\
  {									\
    bbtkBlackBoxDebugMessage("process",1,"**> Processing..."		\
			     <<std::endl);				\
    itkParent::Update();						\
    bbtkBlackBoxDebugMessage("process",2,"<** Processing"		\
			     <<std::endl);				\
  }								

//============================================================================

//===========================================================================
/// EOF
//===========================================================================
#endif
