/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*
 * bbtkSystemTools.h
 *
 *  Created on: Apr 23, 2012
 *      Author: pechan
 */

#ifndef BBTKSYSTEMTOOLS_H_
#define BBTKSYSTEMTOOLS_H_


#include "bbtkSystem.h"
#include <cstdlib>


namespace bbtk
{


class BBTK_EXPORT bbtkSystemTools
{
public:
	bbtkSystemTools();
	virtual ~bbtkSystemTools();
public:
	/**
	 * This method executes CreatePackage
	 */
	static void CreatePackage();
	/**
	 * This method executes CreateBlackBox
	 */
	static void CreateBlackBox();
	/**
	 * This method executes bbi
	 */
	static void ExecuteBbi();
	/**
	 * This method executes creaNewProject
	 */
	static void ExecuteCreaNewProject();
};


}// namespace bbtk


#endif /* BBTKSYSTEMTOOLS_H_ */
