/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWidgetBlackBoxWindow.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.4 $
========================================================================*/


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */



#ifndef __bbtkWidgetBlackBoxWindow_h__
#define __bbtkWidgetBlackBoxWindow_h__


#include "bbtkWidgetBlackBox.h"

namespace bbtk
{


  //==================================================================
  // The base of the hierarchy of windows associated to a WidgetBlackBox
//EED 10/06/2009  /*BBTK_EXPORT*/
  template <class W>
  class /*BBTK_EXPORT*/ WidgetBlackBoxWindow 
  {
  public:
    typedef typename WidgetBlackBox<W>::Pointer WidgetBlackBoxPointer;
    typedef typename WidgetBlackBox<W>::WeakPointer WidgetBlackBoxWeakPointer;

    WidgetBlackBoxWindow(WidgetBlackBoxPointer box);
    virtual ~WidgetBlackBoxWindow();
    virtual void bbShow();
    virtual void bbHide();
    virtual void bbDestroy();
    bool bbIsShown() { return mShown; }
    virtual WidgetBlackBoxPointer bbGetBlackBox() { return mBox.lock(); }
    //virtual wxDialog* bbGetDialog() { return 0; } 
    //virtual wxFrame* bbGetFrame() { return 0; } 
    virtual bool bbIsDialog() { return false; }
    virtual bool bbIsFrame() { return false; }
  private:
    WidgetBlackBoxWeakPointer mBox;
    bool mShown;
  };
  //==================================================================


} //namespace bbtk

#include "bbtkWidgetBlackBoxWindow.txx"

#endif  //__bbtkWidgetBlackBoxWindow_h__

