/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================                                                                               
  Program:   bbtk
  Module:    $RCSfile: bbtkWidgetBlackBoxWindow.txx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/




/**
 *  \file 
 *  \brief 
 */
 

namespace bbtk
{




  //=========================================================================
  // WidgetBlackBoxWindow
  //=========================================================================



  //=========================================================================
  template <class W>
  WidgetBlackBoxWindow<W>::WidgetBlackBoxWindow
  (typename WidgetBlackBox<W>::Pointer box)
    : mBox(box), mShown(false)
  {
    bbtkDebugMessage("widget",9,"WidgetBlackBoxWindow::WidgetBlackBoxWindow("
		     <<mBox.lock()->bbGetName()<<")"<<std::endl);
    mBox.lock()->bbSetWindow(this);
    mBox.lock()->IncNbWindowsAlive();
  }
  //=========================================================================

  //=========================================================================
  template <class W>
  WidgetBlackBoxWindow<W>::~WidgetBlackBoxWindow()
  {
    bbtkDebugMessage("widget",9,
		     "WidgetBlackBoxWindow::~WidgetBlackBoxWindow() "
		     <<this<<std::endl);
    std::cout << "**** WidgetBlackBoxWindow::~WidgetBlackBoxWindow() "
	      <<this<<std::endl;
    bbHide();
    if (!mBox.expired())
      {
	mBox.lock()->DecNbWindowsAlive();
	mBox.lock()->bbSetWindow(0);
      }
  }
  //========================================================================= 


  //=========================================================================
  template <class W>
  void WidgetBlackBoxWindow<W>::bbShow()
  {
    if (bbIsShown()) return;
    bbtkDebugMessage("widget",9,"WidgetBlackBoxWindow::bbShow() ["
		     <<mBox.lock()->bbGetName()<<"]"<<std::endl);
    mBox.lock()->IncNbWindowsShown();
    mShown = true;
    if (bbGetBlackBox()) bbGetBlackBox()->bbUserOnShow();
  }
  //=========================================================================

  //=========================================================================
  template <class W>
  void WidgetBlackBoxWindow<W>::bbHide()
  {
    if ((!bbIsShown())||(mBox.expired())) return;
    bbtkDebugMessage("widget",9,"WidgetBlackBoxWindow::bbHide() ["
		     <<mBox.lock()->bbGetName()<<"]"<<std::endl);
    mBox.lock()->DecNbWindowsShown();
    mShown = false;
  }
  //=========================================================================

  //=========================================================================
  template <class W>
  void WidgetBlackBoxWindow<W>::bbDestroy()
  {
    
    if (mBox.expired()) return;
    bbtkDebugMessage("widget",9,"WidgetBlackBoxWindow::bbDestroy() [" 
		     <<mBox.lock()->bbGetName()<<"]"<<std::endl);
    bbHide();
    mBox.lock()->DecNbWindowsAlive();
    mBox.lock()->bbSetWindow(0);
    
  }
  //=========================================================================



}//namespace bbtk



