/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIPackageBrowser2.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.10 $
=========================================================================*/




/**
 * \brief Short description in one line
 *
 * Long description which
 * can span multiple lines
 */
/**
 * \file
 * \brief
 */
/**
 * \class bbtk::
 * \brief
 */


#ifdef _USE_WXWIDGETS_


#ifndef __bbtkWxGUIPackageBrowser2_h__
#define __bbtkWxGUIPackageBrowser2_h__


#include "bbtkWx.h"

#include "bbtkInterpreter.h"
#include <wx/aui/aui.h>

//Drag and drop
#include <wx/dnd.h>
#include <wx/dataobj.h>
#include "wx/listctrl.h"
// not all ports have support for EVT_CONTEXT_MENU yet, don't define
// USE_CONTEXT_MENU for those which don't
#if defined(__WXMOTIF__) || defined(__WXPM__) || defined(__WXX11__) || defined(__WXMGL__)
    #define USE_CONTEXT_MENU 0
#else
    #define USE_CONTEXT_MENU 1
#endif


namespace bbtk
{
  //================================================================
  class WxGUIPackageBrowser2;
  //================================================================


  //================================================================
  /// Abstract class which defines the callbacks invoked by WxGUIPackageBrowser2
  class BBTK_EXPORT WxGUIPackageBrowser2User
  {
  public:
    WxGUIPackageBrowser2User() {}
    virtual ~WxGUIPackageBrowser2User() {}
    /// Callback invoked when the 'run' button is pressed
    virtual void WxGUIPackageBrowser2Run() {}
  };
  //================================================================


  //================================================================
  class WxGUIBlackBoxInfo : public wxPanel
  {
  public:
    WxGUIBlackBoxInfo(wxWindow* parent);
    ~WxGUIBlackBoxInfo();

    void UpdateInfo(BlackBoxDescriptor* descr);
    void InsertInputOutput(wxListCtrl* l, BlackBoxInputOutputDescriptor* i);
  private:
    BlackBoxDescriptor* mDescriptor;
    wxStaticText* mName;
    wxStaticText* mDescription;
    wxStaticText* mAuthor;
    wxStaticText* mCategory;

    wxListCtrl* mInputList;
    wxListCtrl* mOutputList;
  } ;
  //================================================================

  //================================================================
  class WxGUIBlackBoxListUser
  {
  public:
    WxGUIBlackBoxListUser() {}
    virtual ~WxGUIBlackBoxListUser() {}

    // User callback when a box is selected in the list
    virtual void WxGUIBlackBoxListUserOnSelected( BlackBoxDescriptor* ) {}
  };
  //================================================================

  //================================================================
  class WxGUIBlackBoxList: public wxListCtrl
  {
  public:
    WxGUIBlackBoxList(wxWindow *parent,
		   const wxWindowID id,
		   const wxPoint& pos,
		   const wxSize& size,
		   long style);

    // Set the user of the object
    void SetUser(WxGUIBlackBoxListUser* u) { mUser = u; }

    // add one item to the listctrl in report mode
    void Insert(BlackBoxDescriptor::Pointer d);

    //
    void OnColClick(wxListEvent& event);
    void OnColRightClick(wxListEvent& event);
    void OnColBeginDrag(wxListEvent& event);
    void OnColDragging(wxListEvent& event);
    void OnColEndDrag(wxListEvent& event);
    void OnBeginDrag(wxListEvent& event);
    void OnBeginRDrag(wxListEvent& event);
    void OnBeginLabelEdit(wxListEvent& event);
    void OnEndLabelEdit(wxListEvent& event);
    void OnDeleteItem(wxListEvent& event);
    void OnDeleteAllItems(wxListEvent& event);
#if WXWIN_COMPATIBILITY_2_4
    void OnGetInfo(wxListEvent& event);
    void OnSetInfo(wxListEvent& event);
#endif
    void OnSelected(wxListEvent& event);
    void OnDeselected(wxListEvent& event);
    void OnListKeyDown(wxListEvent& event);
    void OnActivated(wxListEvent& event);
    void OnFocused(wxListEvent& event);
    void OnCacheHint(wxListEvent& event);

    void OnChar(wxKeyEvent& event);

#if USE_CONTEXT_MENU
    void OnContextMenu(wxContextMenuEvent& event);
#endif

    void OnRightClick(wxMouseEvent& event);

private:
    void ShowContextMenu(const wxPoint& pos);
    //    wxLog *m_logOld;
    void SetColumnImage(int col, int image);

    void LogEvent(const wxListEvent& event, const wxChar *eventName);
    void LogColEvent(const wxListEvent& event, const wxChar *eventName);

    virtual wxString OnGetItemText(long item, long column) const;
    virtual int OnGetItemColumnImage(long item, long column) const;
    virtual wxListItemAttr *OnGetItemAttr(long item) const;

    WxGUIBlackBoxListUser* mUser;

    wxListItemAttr m_attr;

    //    DECLARE_NO_COPY_CLASS(WxGUIBlackBoxListCtrl)
    DECLARE_EVENT_TABLE()
};
  //================================================================

  //================================================================
  /// A package browser panel
  class BBTK_EXPORT WxGUIPackageBrowser2 : public wxPanel,
					   public WxGUIBlackBoxListUser
  {
  public:
    WxGUIPackageBrowser2( wxWindow *parent,
			 WxGUIPackageBrowser2User* user = 0 );
    ~WxGUIPackageBrowser2();

    void IncludeAll();
    void BuildFromFactory(Factory::Pointer f);
    void RebuildList();
    bool IsVisible(BlackBoxDescriptor::Pointer d);

    void OnFilter(wxCommandEvent&);

    // User callback when a box is selected in the list
    void WxGUIBlackBoxListUserOnSelected( BlackBoxDescriptor* );

	//RaC
	BlackBoxDescriptor* GetActualSelected();
	Factory::Pointer GetFactory();

  private:
    wxAuiManager				m_mgr;
    WxGUIPackageBrowser2User*	mUser;
    Interpreter::Pointer		mInterpreter;
    Factory::Pointer			mFactory;
    WxGUIBlackBoxList*			mBoxList;
    WxGUIBlackBoxInfo*			mBoxInfo;

    wxTextCtrl					*mPackageFilter;
    wxTextCtrl					*mNameFilter;
    wxTextCtrl					*mDescriptionFilter;
    wxTextCtrl					*mCategoryFilter;
    wxTextCtrl					*mInputTypeFilter;
    wxTextCtrl					*mOutputTypeFilter;
    wxTextCtrl					*mInputNatureFilter;
    wxTextCtrl					*mOutputNatureFilter;

    wxCheckBox					*mShowWidgetsFilter;
    wxCheckBox					*mShowAdaptorsFilter;
    wxCheckBox					*mShowGUIsFilter;

	//RaC
	BlackBoxDescriptor          *_actualSelected;

    bool findnpos(const std::string &strA, const std::string &strB );

   DECLARE_EVENT_TABLE()
  };
  //================================================================


  //================================================================
  /// Browser2 in a frame
  class BBTK_EXPORT WxGUIPackageBrowser2Window : public wxFrame
					      //, public WxGUICommandUser
  {
  public:
    WxGUIPackageBrowser2Window( wxWindow *parent, wxString title, wxSize size);
    ~WxGUIPackageBrowser2Window();
    //    void Open(const std::string& filename) { mBrowser2->Open(filename); }
    //    void WxGUICommandEnter(const std::string& s);


  private :

    WxGUIPackageBrowser2* mBrowser;

  };
   //================================================================


} // namespace bbtk


#endif // __bbtkWxGUIPackageBrowser_h__

#endif //_USE_WXWIDGETS_
