/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbPersistenceCSVReader_h_INCLUDED__
#define __bbPersistenceCSVReader_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkImageData.h>
#include "bbtkSimpleUtilities.h"
#include <fstream>
#include <iostream>
#include <vtkType.h>

namespace bbvtk
{

class bbvtk_EXPORT CSVReader
 :
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CSVReader,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,std::string);
  BBTK_DECLARE_INPUT(InType,int);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();

  vtkImageData* createImage(std::vector< std::vector<double> >, int x, int y, int type);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CSVReader,bbtk::AtomicBlackBox);
BBTK_NAME("CSVReader");
BBTK_AUTHOR("_author_");
BBTK_DESCRIPTION("_description_");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(CSVReader,In,"First input",std::string,"");
BBTK_INPUT(CSVReader,InType,"/Common/vtkType.h",int,"");
BBTK_OUTPUT(CSVReader,Out,"First output",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(CSVReader);
}
// EO namespace bbvtk

#endif // __bbPersistenceCSVReader_h_INCLUDED__

