/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkPolyDataReaderPlus_h_INCLUDED__
#define __bbvtkPolyDataReaderPlus_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkGenericDataObjectReader.h>
#include <vtkUnstructuredGridReader.h>
#include <vtkXMLPolyDataReader.h>
#include <vtkProperty.h>
#include <vtkObject.h>
#include <vtkCommand.h>
#include <vtkPolyData.h>
#include <vtkPolyDataMapper.h>
#include <vtkPolyDataReader.h>
#include <vtkActor.h>
#include <vtkProp3D.h>
#include "names.h"

namespace bbvtk
{

#define OBS_POST_READER_1 1401

class bbvtk_EXPORT PolyDataReaderPlus
 :
   public bbtk::AtomicBlackBox,
   public vtkObject
{
  BBTK_BLACK_BOX_INTERFACE(PolyDataReaderPlus,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(InPath, std::string);
  BBTK_DECLARE_INPUT(InOpacity, double);
  BBTK_DECLARE_INPUT(InColor, std::vector<double>);
  BBTK_DECLARE_INPUT(InPostReadObs1, vtkCommand*);
  BBTK_DECLARE_OUTPUT(Out,vtkPolyData*);
  BBTK_DECLARE_OUTPUT(OutActor,vtkProp3D*);
  BBTK_PROCESS(Process);
  void Process();

  vtkPolyData* informacion;

  bool readed;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PolyDataReaderPlus,bbtk::AtomicBlackBox);
BBTK_NAME("PolyDataReaderPlus");
BBTK_AUTHOR("_author_");
BBTK_DESCRIPTION("_description_");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(PolyDataReaderPlus,InPath,"Path to the file to be readed",std::string,"");
BBTK_INPUT(PolyDataReaderPlus,InOpacity,"",double,"");
BBTK_INPUT(PolyDataReaderPlus,InColor,"",std::vector<double>,"");
BBTK_INPUT(PolyDataReaderPlus,InPostReadObs1,"Who will be notified after persist", vtkCommand*,"");
BBTK_OUTPUT(PolyDataReaderPlus,Out,"Information readed", vtkPolyData*,"");
BBTK_OUTPUT(PolyDataReaderPlus,OutActor,"Information as an actor", vtkProp3D*,"");
BBTK_END_DESCRIBE_BLACK_BOX(PolyDataReaderPlus);
}
// EO namespace bbvtk

#endif // __bbvtkPolyDataReaderPlus_h_INCLUDED__


