/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbvtkSphereList_h_INCLUDED__
#define __bbvtkSphereList_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include <vtkPolyDataMapper.h>
#include <vtkRenderer.h>
#include <vtkSphereSource.h>
#include <vtkLinearTransform.h>


namespace bbvtk
{

class bbvtk_EXPORT SphereList
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(SphereList,bbtk::AtomicBlackBox);

	BBTK_DECLARE_INPUT(Renderer ,vtkRenderer*);
	BBTK_DECLARE_INPUT(lstPointX,std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointY,std::vector<double>);
	BBTK_DECLARE_INPUT(lstPointZ,std::vector<double>);
	BBTK_DECLARE_INPUT(lstRadio ,std::vector<double>);
	BBTK_DECLARE_INPUT(Colour   ,std::vector<double>);
	BBTK_DECLARE_INPUT(Opacity  ,double);
	BBTK_DECLARE_INPUT(Spacing   ,std::vector<double>);
	BBTK_DECLARE_INPUT(Transform   ,vtkLinearTransform*);

  BBTK_DECLARE_OUTPUT(ActorList,std::vector<vtkActor*>);

  BBTK_PROCESS(Process);
  void Process();

  std::vector<vtkActor *> sphereActor;
  std::vector<vtkSphereSource *> vtkspheresourceLst;

private:
   double GetRadio(int);
   void GetPoint(int i, double &px,double &py,double &pz);   
   void GetColor(int i, double &cr,double &cg,double &cb);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(SphereList,bbtk::AtomicBlackBox);
	BBTK_NAME("SphereList");
	BBTK_AUTHOR("InfoTeam  CREATIS");
	BBTK_DESCRIPTION("Builds a sphere list actor given four vectors (X, Y, Z, radius).");
	BBTK_CATEGORY("");
	BBTK_INPUT(SphereList,Renderer,"Renderer",vtkRenderer*,"");
	BBTK_INPUT(SphereList,lstPointX,"List of X coordinates. Requirement: same size as vector Y and vector Z.",std::vector<double>,"");
	BBTK_INPUT(SphereList,lstPointY,"List of Y coordinates. Requirement: same size as vector X and vector Z.",std::vector<double>,"");
	BBTK_INPUT(SphereList,lstPointZ,"List of Z coordinates. Requirement: same size as vector X and vector Y.",std::vector<double>,"");
	BBTK_INPUT(SphereList,lstRadio,"List of Radio values",std::vector<double>,"");
	BBTK_INPUT(SphereList,Colour,"Colour RGB values for the spheres (3 first values of the vector for the first sphere, following values for the second sphere, etc.)",std::vector<double>,"");
	BBTK_INPUT(SphereList,Opacity,"Opacity of the spheres",double,"");
	BBTK_INPUT(SphereList,Spacing,"(default [1 1 1]) Spacing vector [sx sy sz]",std::vector<double>,"");
BBTK_INPUT(SphereList,Transform,"vtkTransform",vtkLinearTransform*,"");

 BBTK_OUTPUT(SphereList,ActorList,"List of the sphere actors",std::vector<vtkActor*>,"");

BBTK_END_DESCRIBE_BLACK_BOX(SphereList);
}
// EO namespace bbvtk

#endif // __bbvtkSphereList_h_INCLUDED__

