/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#ifndef __bbvtkUpdateRender_h_INCLUDED__
#define __bbvtkUpdateRender_h_INCLUDED__
#include "bbvtk_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h" 

namespace bbvtk
{

class bbvtk_EXPORT UpdateRender
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(UpdateRender,bbtk::AtomicBlackBox);
 
  BBTK_DECLARE_INPUT(Renderer,vtkRenderer*);
  BBTK_DECLARE_INPUT(Active,bool);
  
  
  BBTK_PROCESS(Process);
  void Process();

};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(UpdateRender,bbtk::AtomicBlackBox);
BBTK_NAME("UpdateRender");
BBTK_AUTHOR("JLGR");
BBTK_DESCRIPTION("refresh 3d scene");
BBTK_CATEGORY("");
BBTK_INPUT(UpdateRender,Renderer,"Render to update",vtkRenderer*,"");
BBTK_INPUT(UpdateRender,Active,"Enable render update (default is false).",bool,"");

BBTK_END_DESCRIBE_BLACK_BOX(UpdateRender);

}
// EO namespace bbvtk

#endif // __bbvtkUpdateRender_h_INCLUDED__

