/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxColourSelectorButton.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.12 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
*/

/**
 * \class bbwx::ColourSelectorButton
 * \brief 


 */

#ifdef _USE_WXWIDGETS_

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbwxColourSelectorButton_h_INCLUDED_H__
#define __bbwxColourSelectorButton_h_INCLUDED_H__

// Include wxBlackBox definition
#include "bbtkWxBlackBox.h"
#include "bbwx_EXPORT.h"

// Namespace of the package "wx" is "bbwx" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbwx
{


  //------------------------------------------------------------------------
  // The black box
  class bbwx_EXPORT ColourSelectorButton : public bbtk::WxBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(ColourSelectorButton,bbtk::WxBlackBox);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    void Process();
    void CreateWidget(wxWindow*);
  protected:

  };
  //=================================================================

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ColourSelectorButton,bbtk::WxBlackBox);
  // Already inserted for any WxBlackBox  BBTK_CATEGORY("widget");
  BBTK_NAME("ColourSelectorButton");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("A button which displays a colour picker dialog when clicked");
  BBTK_INPUT(ColourSelectorButton,In,"Initial colour",std::string,"colour");
  BBTK_OUTPUT(ColourSelectorButton,Out,"Colour choosen in format '[0,1] [0,1] [0,1]'",std::string,"colour");
  BBTK_END_DESCRIBE_BLACK_BOX(ColourSelectorButton);
  //=================================================================

}//namespace bbtk
#endif  // __bbtkWxColourSelector_h__

#endif //USE_WXWIDGETS
