/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxCommandButton.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.10 $
=========================================================================*/

/**
 * \brief Short description in one line 
 *  
 * Long description which  
 * can span multiple lines 
 */ 
/** 
 * \file  
 * \brief 
 */ 
/** 
 * \class CommandButton
 * \brief 
 */ 
 
 
#ifdef USE_WXWIDGETS
 
#ifndef __bbwxCommandButton_h_INCLUDED_H__ 
#define __bbwxCommandButton_h_INCLUDED_H__ 
 
 
#include "bbtkWxBlackBox.h" 
#include "bbwx_EXPORT.h"
 
 
namespace bbwx 
{ 
  
  //--------------------------------------------------------------------------
  class bbwx_EXPORT CommandButton : public bbtk::WxBlackBox 
  {     
    friend class CommandButtonWidget;
    BBTK_BLACK_BOX_INTERFACE(CommandButton,bbtk::WxBlackBox); 
    BBTK_DECLARE_INPUT(In, std::string ); 	
    BBTK_DECLARE_INPUT(Label, std::string ); 
    BBTK_DECLARE_INPUT(Colour, std::vector<double> ); 	
    //    BBTK_DECLARE_OUTPUT(Out,int); 
    BBTK_PROCESS(Process); 
    void Process(); 
    BBTK_CREATE_WIDGET(CreateWidget);
    void CreateWidget(wxWindow*);
  protected: 
    
    
  private: 
    void UpdateColour();
    void UpdateLabel();
  }; 
  
  //================================================================= 
  // UserBlackBox description 
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(CommandButton,bbtk::WxBlackBox); 
  BBTK_NAME("CommandButton"); 
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr"); 
  BBTK_DESCRIPTION("Button which executes bbi commands"); 
  
  typedef std::vector<double> vectorcolour;
  
  BBTK_INPUT(CommandButton,In,"Commands to be executed separated by commas (;). Each single quote (') is replaced by a double quote (\").",std::string,"");   
  BBTK_INPUT(CommandButton,Label,"Label of the button",std::string,""); 
  BBTK_INPUT(CommandButton,Colour,"Colour of the button (-1 -1 -1  Background)",vectorcolour,"colour"); 
  //	BBTK_OUTPUT(CommandButton,Out,"..Out..",int); 
  BBTK_END_DESCRIBE_BLACK_BOX(CommandButton); 
  //================================================================= 
  
  
}//namespace  bbwx 

#endif  // __bbwxCommandButton_h_INCLUDED_H__ 

#endif //USE_WXWIDGETS
