/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbwxDirectorySelector.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:14 $
  Version:   $Revision: 1.8 $
=========================================================================*/


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file bbwxDirectorySelector.h
 * \brief 
 */
/**
 * \class DirectorySelector
 * \brief 
 */


#ifdef USE_WXWIDGETS


#ifndef __bbWxDirectorySelector_h__
#define __bbWxDirectorySelector_h__

#include "bbtkAtomicBlackBox.h"
#include "bbwx_EXPORT.h"

namespace bbwx
{
  
  
  

  //=================================================================
  class bbwx_EXPORT DirectorySelector : public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(DirectorySelector,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(Message,std::string);
    BBTK_DECLARE_INPUT(DefaultDir,std::string);
    BBTK_DECLARE_INPUT(DefaultDirectory,std::string);
    BBTK_DECLARE_INPUT(Wildcard,std::string);
    BBTK_DECLARE_INPUT(OpenSave,std::string);
    BBTK_DECLARE_OUTPUT(Out,std::string);
    BBTK_PROCESS(Process);
    void Process();
  };
  //=================================================================
  
 
  //=================================================================
  // AtomicBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(DirectorySelector,bbtk::AtomicBlackBox);
  BBTK_NAME("DirectorySelector");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_CATEGORY("widget, Selector");
  BBTK_DESCRIPTION("Pops up a directory selection dialog (wxDirDialog)");
  BBTK_INPUT(DirectorySelector,Title,     "Title of the dialog",                std::string,"directory name");
  BBTK_INPUT(DirectorySelector,Message,   "Message to show on the dialog",      std::string,"");
  BBTK_INPUT(DirectorySelector,DefaultDir,"The default directory",              std::string,"directory name");
  BBTK_OUTPUT(DirectorySelector,Out,      "The directory selected by the user", std::string,"directory name");
  BBTK_END_DESCRIBE_BLACK_BOX(DirectorySelector);
  //=================================================================



}



//namespace bbtk
#endif  //__bbtkWxDirectorySelector_h__

#endif //USE_WXWIDGETS
