/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbwxvtkViewer2D.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:52:36 $
  Version:   $Revision: 1.19 $

                                                                                
=========================================================================*//**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class Viewer2D
 * \brief 
 */

#ifdef USE_WXWIDGETS
#ifdef USE_VTK

#ifndef __bbwxvtkViewer2D_h__
#define __bbwxvtkViewer2D_h__

#include "vtkImageData.h"
#include "wxvtkImageViewer2.h"
#include "vtkImplicitPlaneWidget.h"

#include "bbtkWxBlackBox.h"
#include "wxVTKRenderWindowInteractor.h"

namespace bbwxvtk
{
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  //------------------------------------------------------------------------
  
  class /*BBTK_EXPORT*/ Viewer2D : public bbtk::WxBlackBox
  {    
    BBTK_BLACK_BOX_INTERFACE(Viewer2D,bbtk::WxBlackBox);
    
    BBTK_DECLARE_INPUT(Slice,       int);
    BBTK_DECLARE_INPUT(Interpolate, bool);  // JP
    BBTK_DECLARE_INPUT(Orientation, int);    
    BBTK_DECLARE_INPUT(In,          vtkImageData *);
    BBTK_DECLARE_OUTPUT(Out,        int);
    
    BBTK_DECLARE_OUTPUT(Renderer,vtkRenderer*);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    //   BBTK_ON_SHOW_WIDGET(OnShowWidget);
    
    void Process();
    void CreateWidget(wxWindow*);
    //    void OnShowWidget();

  };
   
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(Viewer2D,bbtk::WxBlackBox);
  BBTK_NAME("Viewer2D");
  BBTK_AUTHOR("eduardo.davila@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("2D Viewer widget (vtk)");
  BBTK_CATEGORY("viewer");
  BBTK_INPUT(Viewer2D, Slice,       "Initial Slice number",                     int,            "");
  BBTK_INPUT(Viewer2D, Orientation, "Slicing orientation : 0:yz / 1:xz / 2:xy", int,            "");
  BBTK_INPUT(Viewer2D, Interpolate, "Pixels interpolation: true/false        ", bool,           ""); // JP
  BBTK_INPUT(Viewer2D, In,          "Input Image",                              vtkImageData *, "");
  BBTK_OUTPUT(Viewer2D,Out,         "Current Slice number",                     int,            "");
  BBTK_OUTPUT(Viewer2D,Renderer,    "vtk Renderer",                             vtkRenderer*,   "");
  BBTK_END_DESCRIBE_BLACK_BOX(Viewer2D);
  //=================================================================

}//namespace bbwxvtk

#endif  //__bbwxvtkViewer2D_h__

#endif //USE_VTK
#endif //USE_WXWIDGETS
