/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
#ifndef BRUKER2DICOM2_H
#define BRUKER2DICOM2_H

#include <gdcmReader.h>
#include "gdcmDirectory.h"
#include <vtkGDCMImageReader.h>
#include <gdcmScanner.h>

#include "gdcmByteSwap.h"
#include "gdcmSwapCode.h"
#include "gdcmFilename.h"
#include "gdcmDataSet.h"

#include "gdcmImageWriter.h"
#include "gdcmImage.h"
#include "gdcmWriter.h"
#include "gdcmReader.h"
#include "gdcmUIDGenerator.h"
//
//#include "gdcmFile.h"
//#include "gdcmFileHelper.h"
//#include "gdcmCommon.h"
//#include "gdcmDebug.h"
//#include "gdcmUtil.h"
//#include "gdcmDirList.h"
//
//#include "gdcmArgMgr.h"
#include "brukerSystem.h"
#include "brukerdataset.h"
#include "brukerkspaceobject.h"
#include "brukerimage.h"
#include <string>
#include <iostream>
#include <sstream>

  // file separator
#if defined(_WIN32)
#define VALID_FILE_SEPARATOR "\\"
#define INVALID_FILE_SEPARATOR "/"
#else
#define INVALID_FILE_SEPARATOR "\\"
#define VALID_FILE_SEPARATOR "/"
#endif

//class __declspec( dllexport ) Bruker2Dicom {
class /*creaBruker_EXPORT*/  Bruker2Dicom 
{

public:
 /*! \brief Constructor
*/
  Bruker2Dicom () /* : verbose(0), mhd(0), dicom(0), day(O)*/ {};
/*! \brief Destructor
*/
  ~Bruker2Dicom (){};

  void SetInputDirectory (const std::string &i) { InputDirName   = i;}
  void SetOutputDirectory(const std::string &o) { OutputDirName  = o;}
  void SetConvertModeToDicom()                  { dicom = 1; mhd = 0;}
  void SetConvertModeToMhd()                    { dicom = 0; mhd = 1;}  
  bool Execute();
  
  /* 
  // For debugging pupose only.
  //Don't need accessors : Attributes are 'public' 
  
  void SetVerbose(int v) { verbose = v;}
  void SetMhd(int m)     { mhd = m;    }
  void SetDicom(int d)   { dicom = d;  }
  */     

private :

void MakeDicomImage(unsigned char *tabPixels, 
              int X, 
              int Y,
              int nbFrames,
              int pixelSize,
              double spacingX, double spacingY, double sliceDistance, 
              std::string dcmImageName,
              const std::string &patientName,
              const char *day,
              std::string &studyUID,
              std::string &serieUID,
              std::string &studyDescr,
              std::string &serieDescr,
	      std::string &strStudyTimeDate,
              int imgNum, int  imagecontenttype//gdcm2 dont have such things, I think, as ImageContentTYpe 
      );
      
std::vector<BrukerImage> CreateImageSet ( );

void getImhDataType(BrukerFieldData &bDPT, 
                    std::string &mhdDataPixelType, 
		    int &pixelSize);
		    
void cleanString(std::string &s);

bool CreateDirectory(const std::string &dirNameout);

int CheckUserDirectory(std::string &userDirName);
void DealWithMultiStudyDirectory(gdcm::Directory::FilenamesType &fileNames, const std::string &currentOutputDirName);
void DealWithSingleStudyDirectory (const std::string dirname,               const std::string currentOutputDirName) ;

void DealWithNiveau1(std::string level1Directory, std::string currentOutputDirName);
void DealWithNiveau2(std::string level2Directory, std::string currentOutputDirName);
void DealWithNiveau3(std::string &level3Directory, std::string &currentOutputDirName);
		    
void dealWithCarto(gdcm::Directory::FilenamesType &fileNames, int NX, int NY, int nbSlices, 
                   double fovX, double fovY, double sliceDistance,
                   char *copyFile, std::string &currentOutputDirName, 
		   char *outputMhdFileName, char *output2dseqCartoName);

const std::string createDirectory(const std::string &i_name,const std::string &i_dir);
 std::string findFile(const std::string &i_dir, const std::string i_name);
public:

// these ones are for debugging only
// don't bbfy the accessors.

   int verbose;
   const char *day;
       
private :
   std::string InputDirName;
   std::string OutputDirName;

   bool subjectFound;
   bool acqpFound;
   
   std::string subject_entry;
   std::string subject_position;
   std::string subject_date;
   std::string subject_study_name;
 
   int mhd;
   int dicom;
     
   int nbSlices;
   BrukerDataSet br_subject;
   BrukerDataSet br_acqp;
   BrukerDataSet br_method;
   BrukerDataSet br_d3proc;
   BrukerDataSet br_isa;
   BrukerDataSet br_reco;

   std::vector<BrukerImage> imageSet;

// For DICOM images.

   std::string strStudyUID; 
   std::string strSerieUID; 
   std::string strStudyDescr; 
   std::string strSerieDescr;
   std::string strStudyTimeDate;
   std::string strPatientName;
   std::string subject_name; // cleaned strPatientName
 
   int serieNumber;
   int instanceNumber;      
};

#endif
