/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
//
#ifndef BRUKEREXCEPTION_H
#define BRUKEREXCEPTION_H

#include "brukerSystem.h"
#include <exception>
#include <string>


class /*creaBruker_EXPORT*/ BrukerSizeException: public std::exception
{
public:
    BrukerSizeException( const std::string& message,
		      int lgt,
		      int expected_lgt
		      )
      : m_message(message), m_lgt(lgt), m_expected_lgt(expected_lgt)
    {}

    ~BrukerSizeException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
   int getFoundLgt() const throw() {
        return m_lgt;
   }
   
   int getExpectedLgt() const throw() {
        return m_expected_lgt;
   }
     
private:
   std::string m_message;
   int m_lgt;
   int m_expected_lgt;

};


class creaBruker_EXPORT BrukerInitException: public std::exception
{
public:
    BrukerInitException( const std::string& message
		      )
      : m_message(message)
    {}

    ~BrukerInitException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
     
private:
   std::string m_message;

};

class creaBruker_EXPORT BrukerHopelessException: public std::exception
{
public:
    BrukerHopelessException( const std::string& message
		      )
      : m_message(message)
    {}

    ~BrukerHopelessException() throw() {}
    
    virtual const char* what() const throw() {
        return m_message.c_str();
    }
    
     
private:
   std::string m_message;

};

#endif
