/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
//
// C++ Interface: brukerobjectvaryingproperties
//
// Description: 
//
//
// Author: denis grenier <denis.grenier@creatis.univ-lyon1.fr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BRUKEROBJECTVARYINGPROPERTIES_H
#define BRUKEROBJECTVARYINGPROPERTIES_H
#include <cstdlib>
#include <stdlib.h>
#include <string>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <fstream>
#include <map>
#include <algorithm>
#include "boost/regex.hpp"
#include "brukerFieldData.h"
#include "brukerSystem.h"

/**
	@author denis grenier <denis.grenier@creatis.univ-lyon1.fr>
*/
class  /*creaBruker_EXPORT*/ BrukerObjectVaryingProperties{
public:	
   BrukerObjectVaryingProperties();
   ~BrukerObjectVaryingProperties();
   
   double getTE               (unsigned int theValue) const;
   double getPositionP        (unsigned int theValue) const;
   double getPositionR        (unsigned int theValue) const;
   double getPositionS        (unsigned int theValue) const;
   double getPositionTimePerNR(unsigned int theValue) const;
   int    getAcquisitionOrder (unsigned int theValue) const;

   std::vector<std::vector<double> > getOrientation(unsigned int theValue) const;

   bool init(std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);

private:

   void computePositionTimePerNR (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computeOrientation       (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computeAcquisitionOrder  (std::map<std::string, BrukerFieldData> &BrukerHM, std::vector<int> &LoopStruct);
   void computePositionS         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computePositionR         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computePositionP         (std::map<std::string, BrukerFieldData> &BrukerHM);
   void computeTE                (std::map<std::string, BrukerFieldData> &BrukerHM);
   std::vector<double> TE;
   std::vector<double> PositionR;
   std::vector<double> PositionP;
   std::vector<double> PositionS;
   std::vector<double> PositionTimePerNR;
   std::vector<int>    AcquisitionOrder;
   std::vector<std::vector<std::vector <double> > > Orientation;
};

#endif
