/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ConceptDataWrap_h_INCLUDED_H__
#define __ConceptDataWrap_h_INCLUDED_H__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream> 
#include <string>

/** file ConceptDataWrap.h */


//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------
class ConceptDataWrap {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	ConceptDataWrap(std::string theName = "");

	~ConceptDataWrap();

	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	/**
	* Sets the data concept values and name
	* @param theName The name of the concept 
	* @param minRepresent The minRepresent value of the concept 
	* @param maxRepresent The maxRepresent value of the concept 
	* @param minShowed The minShowed value of the concept 
	* @param maxShowed The maxShowed value of the concept 
	* @param actualShow The actualShow value of the concept 
	*/
	void fillData( std::string theName, int minRepresent, int maxRepresent, int minShowed, int maxShowed, int actualShow );

	std::string getName();

	int getMinShowedValue();

	int getMaxShowedValue();

	void setMinValue(int theMin);

	int getMinValue();

	void setMaxValue(int theMax);

	int getMaxValue();

	void setActualValue(int theActual);

	int getActualValue();

	bool isEmpty( );

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	int _minValue;

	int _maxValue;

	int _minShow;

	int _maxShow;

	int _actual;

	std::string _name;


};
#endif // __ConceptDataWrap_HEADER_FILE__
 
 
