/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __CONTOUR_THING__
#define __CONTOUR_THING__



//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include "CommandObject.h"
#include "ExecutableCommand.h"
#include "ComposedCommand.h"
#include "manualContourModel.h"

class ContourThing{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/*
	* Creates a ContourThing 
	*/
	ContourThing(manualBaseModel * model);

	/*
	* Destroys a ContourThing 
	*/
	~ContourThing();
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* 
	*/
	std::string getName();

	/*
	*
	*/
	void setName(std::string  aName);

	
	manualBaseModel * getModel();

	void setModel(manualBaseModel * model);

	/*
	* Executes the given command if posible and returns is posible or not
	* @param theSpecificCommand Is the specific command to execute
	* @return Returns if the command was successfuly executed
	*/
	bool executeCommand (CommandObject * theSpecificCommand);

	/*
	* Interprets the given command and constructs the opposite command for returning it
	* @param theSpecificDOCommand Is the specific DO command 
	* @return Returns the UNDO command of the given one
	*/
	CommandObject * getUndoCommandOf(CommandObject * theSpecificDOCommand);


//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

private: 	
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------

	std::string outlineName;

	manualBaseModel * theModel;
};
#endif
