/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __IMAGE_SOURCE_THING__
#define __IMAGE_SOURCE_THING__



//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include <iostream>
#include "vtkImageData.h" 
/*
* Represents the image source, is named the source because is the base for all calculus with the complete loaded image needeed
*/
class ImageSourceThing{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	
	/*
	* Creates the source image with the given parameter
	* @param sourceImage The image source to set.
	*/
	ImageSourceThing(vtkImageData * theSource);

	/*
	* Destroys the image source
	*/
	~ImageSourceThing();
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Gets the source image 
	* @return sourceImage The image source.
	*/
	vtkImageData * getSourceImage();

	/*
	* Sets the source image 
	* @param sourceImage The image source to set.
	*/
	void setSourceImage( vtkImageData *  theSource);

	/**
	* Gets the max value of the x-axis
	* @return x-extend_MAX
	*/
	int getMax_X();

	/**
	* Gets the min value of the x-axis
	* @return x-extend_MIN
	*/
	int getMin_X();

	/**
	* Gets the range values of the x-axis
	* @return x-extend pointer to a 2 sized []
	*/
	int * getRangeX();

	/**
	* Gets the max value of the y-axis
	* @return y-extend_MAX
	*/
	int getMax_Y();

	/**
	* Gets the min value of the y-axis
	* @return y-extend_MIN
	*/
	int getMin_Y();

	
	/**
	* Gets the range values of the y-axis
	* @return y-extend pointer to a 2 sized []
	*/
	int * getRangeY();

	/**
	* Gets the max value of the z-axis
	* @return z-extend_MAX
	*/
	int getMax_Z();

	/**
	* Gets the min value of the z-axis
	* @return z-extend_MIN
	*/
	int getMin_Z();

	
	/**
	* Gets the range values of the z-axis
	* @return z-extend pointer to a 2 sized []
	*/
	int * getRangeZ();

	
	/**
	* Gets the range values of the x-axis
	* @return x-extend pointer to a 6 sized []
	*/
	int * getAllRanges();
	

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

private: 	
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------

	/*
	* Represents the source image
	*/
	vtkImageData * sourceImage;
};
#endif
