/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __PerformingOperation_h_INCLUDED_H__
#define __PerformingOperation_h_INCLUDED_H__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include <vector>


/** file PerformingOperation.h */


//------------------------------------------------------------------------------------------------------------
// Class definition
//------------------------------------------------------------------------------------------------------------
class PerformingOperation {

	public:

	//------------------------------------------------------------------------------------------------------------
	// Constructors & Destructors
	//------------------------------------------------------------------------------------------------------------

	PerformingOperation();

	~PerformingOperation();

	
	//------------------------------------------------------------------------------------------------------------
	//  Attributes getters and setters
	//------------------------------------------------------------------------------------------------------------
	
	void setStartOperationInstantVector( std::vector<int> instantData );

	std::vector<int> getStartOperationInstantVector( );

	void setEndOperationInstantVector( std::vector<int> instantData );

	std::vector<int> getEndOperationInstantVector( );

	char getStartCommand();

	void setStartCommand( char theCommand );

	char getEndCommand();

	void setEndCommand( char theCommand );

	std::vector<std::string> getKeyNamesOperationElems( );

	void setKeyNamesOperationElems( std::vector<std::string> dataVector);

	//------------------------------------------------------------------------------------------------------------
	//  Other functional methods
	//------------------------------------------------------------------------------------------------------------

	void reset();

private:
	//------------------------------------------------------------------------------------------------------------
	//  Private methods
	//------------------------------------------------------------------------------------------------------------

	//------------------------------------------------------------------------------------------------------------
	// Creational and initialization methods
	//------------------------------------------------------------------------------------------------------------

		
	//------------------------------------------------------------------------------------------------------------
	// Attributtes
	//------------------------------------------------------------------------------------------------------------
	
	std::vector<int>  _startOperationInstantVector;

	std::vector<int>  _endOperationInstantVector;

	std::vector<std::string> _keyNamesOperationElems;

	char _startCommand;

	char _endCommand;

};
#endif // __PerformingOperation_HEADER_FILE__



