/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __interfToolsSpreadPanelH__
#define __interfToolsSpreadPanelH__

#include <wx/wx.h>
#include <wx/radiobox.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/scrolwin.h>
#include <wx/list.h>


#include "interfMenuBar.h"

class interfToolsSpreadPanel 
	: public wxPanel
{
public:
	interfToolsSpreadPanel(wxWindow * parent, int sizex, int sizey,wxEvtHandler* evtHandler);		
	~interfToolsSpreadPanel();

	/**
	**	Adds a new checkbox to the scrolledwindow using the checkboxsizer
	**	@Params id of contour
	**	
	**/
	void addContourCheckBox(std::string id);

	/**
	**	Removes a checkbox from the list of checkboxes in the flexsizer (checkboxsizer)
	**	@Params id of contour
	**	
	**/
	void removeContourCheckBox(std::string id);

private:
	wxPanel* resetbuttxt;
	wxPanel* gobuttxt;
	wxPanel* radiobox;
	wxPanel* addremovecont;
//Atributes for managing the events of adding and removing the checkbox
	wxScrolledWindow* scrollwin;
	wxFlexGridSizer* checkboxsizer;
	std::vector<std::string> checkvect;
	


	/**
	**	initializes the radio box to display the options of the spread method.
	**/
	wxPanel* initializeRadioBox();

	/**
	**	initializes the button and the text to be displayed
	**	it returns a panel with both components
	**	@param Path of the image to be used in the button
	**	@param nom	text to be displayed at right of the button
	**/
	wxPanel* initializeButton(std::string path, std::string nom);

	/**
	**	initializes the panel that has all the contours that exist in the interface
	**	every time a contour is added into the scene, it must be added into this panel
	**	for all the contours it must exist a check box beside the contour.
	**	This checkbox controls the contours that are going to be used in the spread function.
	**/

	wxPanel* initializeAddRemoveContour();

	


};

#endif

